@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.GetRegistryComponentVersionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property componentName Container name.
 * @property registryName Name of Azure Machine Learning registry. This is case-insensitive
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property version Version identifier.
 */
public data class GetRegistryComponentVersionPlainArgs(
    public val componentName: String,
    public val registryName: String,
    public val resourceGroupName: String,
    public val version: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.GetRegistryComponentVersionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.GetRegistryComponentVersionPlainArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.GetRegistryComponentVersionPlainArgs.builder()
            .componentName(componentName.let({ args0 -> args0 }))
            .registryName(registryName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .version(version.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRegistryComponentVersionPlainArgs].
 */
@PulumiTagMarker
public class GetRegistryComponentVersionPlainArgsBuilder internal constructor() {
    private var componentName: String? = null

    private var registryName: String? = null

    private var resourceGroupName: String? = null

    private var version: String? = null

    /**
     * @param value Container name.
     */
    @JvmName("pcjfraxpjfdbpcld")
    public suspend fun componentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.componentName = mapped
    }

    /**
     * @param value Name of Azure Machine Learning registry. This is case-insensitive
     */
    @JvmName("mqdngnsvayrnexjr")
    public suspend fun registryName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.registryName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tbuulfaqhpjerhsf")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Version identifier.
     */
    @JvmName("iqsqfdvrpqxjqeaj")
    public suspend fun version(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.version = mapped
    }

    internal fun build(): GetRegistryComponentVersionPlainArgs = GetRegistryComponentVersionPlainArgs(
        componentName = componentName ?: throw PulumiNullFieldException("componentName"),
        registryName = registryName ?: throw PulumiNullFieldException("registryName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        version = version ?: throw PulumiNullFieldException("version"),
    )
}
