@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.GetSchedulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name Schedule name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceName Name of Azure Machine Learning workspace.
 */
public data class GetSchedulePlainArgs(
    public val name: String,
    public val resourceGroupName: String,
    public val workspaceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.GetSchedulePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.GetSchedulePlainArgs = com.pulumi.azurenative.machinelearningservices.inputs.GetSchedulePlainArgs.builder()
        .name(name.let({ args0 -> args0 }))
        .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
        .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSchedulePlainArgs].
 */
@PulumiTagMarker
public class GetSchedulePlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var resourceGroupName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value Schedule name.
     */
    @JvmName("hokbltcbnowicupi")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ujyedgbsshprubju")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("btabpnqglpjekrga")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetSchedulePlainArgs = GetSchedulePlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
    )
}
