@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.HDInsightArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * A HDInsight compute.
 * @property computeLocation Location for the underlying compute
 * @property computeType The type of compute
 * Expected value is 'HDInsight'.
 * @property description The description of the Machine Learning compute.
 * @property disableLocalAuth Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
 * @property properties HDInsight compute properties
 * @property resourceId ARM resource id of the underlying compute
 */
public data class HDInsightArgs(
    public val computeLocation: Output<String>? = null,
    public val computeType: Output<String>,
    public val description: Output<String>? = null,
    public val disableLocalAuth: Output<Boolean>? = null,
    public val properties: Output<HDInsightPropertiesArgs>? = null,
    public val resourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.HDInsightArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.HDInsightArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.HDInsightArgs.builder()
            .computeLocation(computeLocation?.applyValue({ args0 -> args0 }))
            .computeType(computeType.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .disableLocalAuth(disableLocalAuth?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceId(resourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HDInsightArgs].
 */
@PulumiTagMarker
public class HDInsightArgsBuilder internal constructor() {
    private var computeLocation: Output<String>? = null

    private var computeType: Output<String>? = null

    private var description: Output<String>? = null

    private var disableLocalAuth: Output<Boolean>? = null

    private var properties: Output<HDInsightPropertiesArgs>? = null

    private var resourceId: Output<String>? = null

    /**
     * @param value Location for the underlying compute
     */
    @JvmName("fffnuamytalwpnao")
    public suspend fun computeLocation(`value`: Output<String>) {
        this.computeLocation = value
    }

    /**
     * @param value The type of compute
     * Expected value is 'HDInsight'.
     */
    @JvmName("qwqxywgbaljeqfyr")
    public suspend fun computeType(`value`: Output<String>) {
        this.computeType = value
    }

    /**
     * @param value The description of the Machine Learning compute.
     */
    @JvmName("dxptcrckjbptyunq")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
     */
    @JvmName("jxynwphmyvtkdsvt")
    public suspend fun disableLocalAuth(`value`: Output<Boolean>) {
        this.disableLocalAuth = value
    }

    /**
     * @param value HDInsight compute properties
     */
    @JvmName("htdqbjowjelwcnme")
    public suspend fun properties(`value`: Output<HDInsightPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value ARM resource id of the underlying compute
     */
    @JvmName("jqderiinqkklpcay")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value Location for the underlying compute
     */
    @JvmName("tewbaipgllcebkfe")
    public suspend fun computeLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computeLocation = mapped
    }

    /**
     * @param value The type of compute
     * Expected value is 'HDInsight'.
     */
    @JvmName("pbwanjlbbwktvmea")
    public suspend fun computeType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.computeType = mapped
    }

    /**
     * @param value The description of the Machine Learning compute.
     */
    @JvmName("jwdqnaybhicgjqce")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
     */
    @JvmName("wmfpfnxhtagqndbq")
    public suspend fun disableLocalAuth(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableLocalAuth = mapped
    }

    /**
     * @param value HDInsight compute properties
     */
    @JvmName("gbbgjsqrkchklltv")
    public suspend fun properties(`value`: HDInsightPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument HDInsight compute properties
     */
    @JvmName("eytckrdckbqrennd")
    public suspend fun properties(argument: suspend HDInsightPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = HDInsightPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value ARM resource id of the underlying compute
     */
    @JvmName("tphbhnpfvgmltjwi")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    internal fun build(): HDInsightArgs = HDInsightArgs(
        computeLocation = computeLocation,
        computeType = computeType ?: throw PulumiNullFieldException("computeType"),
        description = description,
        disableLocalAuth = disableLocalAuth,
        properties = properties,
        resourceId = resourceId,
    )
}
