@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.ImageClassificationMultilabelArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.ClassificationMultilabelPrimaryMetrics
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.LogVerbosity
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Image Classification Multilabel. Multi-label image classification is used when an image could have one or more labels
 * from a set of labels - e.g. an image could be labeled with both 'cat' and 'dog'.
 * @property limitSettings [Required] Limit settings for the AutoML job.
 * @property logVerbosity Log verbosity for the job.
 * @property modelSettings Settings used for training the model.
 * @property primaryMetric Primary metric to optimize for this task.
 * @property searchSpace Search space for sampling different combinations of models and their hyperparameters.
 * @property sweepSettings Model sweeping and hyperparameter sweeping related settings.
 * @property targetColumnName Target column name: This is prediction values column.
 * Also known as label column name in context of classification tasks.
 * @property taskType AutoMLJob Task type.
 * Expected value is 'ImageClassificationMultilabel'.
 * @property trainingData [Required] Training data input.
 * @property validationData Validation data inputs.
 * @property validationDataSize The fraction of training dataset that needs to be set aside for validation purpose.
 * Values between (0.0 , 1.0)
 * Applied when validation dataset is not provided.
 */
public data class ImageClassificationMultilabelArgs(
    public val limitSettings: Output<ImageLimitSettingsArgs>,
    public val logVerbosity: Output<Either<String, LogVerbosity>>? = null,
    public val modelSettings: Output<ImageModelSettingsClassificationArgs>? = null,
    public val primaryMetric: Output<Either<String, ClassificationMultilabelPrimaryMetrics>>? = null,
    public val searchSpace: Output<List<ImageModelDistributionSettingsClassificationArgs>>? = null,
    public val sweepSettings: Output<ImageSweepSettingsArgs>? = null,
    public val targetColumnName: Output<String>? = null,
    public val taskType: Output<String>,
    public val trainingData: Output<MLTableJobInputArgs>,
    public val validationData: Output<MLTableJobInputArgs>? = null,
    public val validationDataSize: Output<Double>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.ImageClassificationMultilabelArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.ImageClassificationMultilabelArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.ImageClassificationMultilabelArgs.builder()
            .limitSettings(limitSettings.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .logVerbosity(
                logVerbosity?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .modelSettings(modelSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .primaryMetric(
                primaryMetric?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .searchSpace(
                searchSpace?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .sweepSettings(sweepSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .targetColumnName(targetColumnName?.applyValue({ args0 -> args0 }))
            .taskType(taskType.applyValue({ args0 -> args0 }))
            .trainingData(trainingData.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .validationData(validationData?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .validationDataSize(validationDataSize?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImageClassificationMultilabelArgs].
 */
@PulumiTagMarker
public class ImageClassificationMultilabelArgsBuilder internal constructor() {
    private var limitSettings: Output<ImageLimitSettingsArgs>? = null

    private var logVerbosity: Output<Either<String, LogVerbosity>>? = null

    private var modelSettings: Output<ImageModelSettingsClassificationArgs>? = null

    private var primaryMetric: Output<Either<String, ClassificationMultilabelPrimaryMetrics>>? = null

    private var searchSpace: Output<List<ImageModelDistributionSettingsClassificationArgs>>? = null

    private var sweepSettings: Output<ImageSweepSettingsArgs>? = null

    private var targetColumnName: Output<String>? = null

    private var taskType: Output<String>? = null

    private var trainingData: Output<MLTableJobInputArgs>? = null

    private var validationData: Output<MLTableJobInputArgs>? = null

    private var validationDataSize: Output<Double>? = null

    /**
     * @param value [Required] Limit settings for the AutoML job.
     */
    @JvmName("clhwbfsqqxjaafun")
    public suspend fun limitSettings(`value`: Output<ImageLimitSettingsArgs>) {
        this.limitSettings = value
    }

    /**
     * @param value Log verbosity for the job.
     */
    @JvmName("qwbxunnjaawfgqak")
    public suspend fun logVerbosity(`value`: Output<Either<String, LogVerbosity>>) {
        this.logVerbosity = value
    }

    /**
     * @param value Settings used for training the model.
     */
    @JvmName("ncehailbqndorphu")
    public suspend fun modelSettings(`value`: Output<ImageModelSettingsClassificationArgs>) {
        this.modelSettings = value
    }

    /**
     * @param value Primary metric to optimize for this task.
     */
    @JvmName("hkwhuqckmwoeyqlp")
    public suspend fun primaryMetric(`value`: Output<Either<String, ClassificationMultilabelPrimaryMetrics>>) {
        this.primaryMetric = value
    }

    /**
     * @param value Search space for sampling different combinations of models and their hyperparameters.
     */
    @JvmName("ucfhyqmbcqpumhki")
    public suspend fun searchSpace(`value`: Output<List<ImageModelDistributionSettingsClassificationArgs>>) {
        this.searchSpace = value
    }

    @JvmName("mxqyboohngqxaeap")
    public suspend fun searchSpace(vararg values: Output<ImageModelDistributionSettingsClassificationArgs>) {
        this.searchSpace = Output.all(values.asList())
    }

    /**
     * @param values Search space for sampling different combinations of models and their hyperparameters.
     */
    @JvmName("mhpbgvbrxhyblqfd")
    public suspend fun searchSpace(values: List<Output<ImageModelDistributionSettingsClassificationArgs>>) {
        this.searchSpace = Output.all(values)
    }

    /**
     * @param value Model sweeping and hyperparameter sweeping related settings.
     */
    @JvmName("odicbdmfnerenunu")
    public suspend fun sweepSettings(`value`: Output<ImageSweepSettingsArgs>) {
        this.sweepSettings = value
    }

    /**
     * @param value Target column name: This is prediction values column.
     * Also known as label column name in context of classification tasks.
     */
    @JvmName("vhsexdvbvbnabiok")
    public suspend fun targetColumnName(`value`: Output<String>) {
        this.targetColumnName = value
    }

    /**
     * @param value AutoMLJob Task type.
     * Expected value is 'ImageClassificationMultilabel'.
     */
    @JvmName("whpuwrvlwkksxgmy")
    public suspend fun taskType(`value`: Output<String>) {
        this.taskType = value
    }

    /**
     * @param value [Required] Training data input.
     */
    @JvmName("gbnghkrdwgjhdppt")
    public suspend fun trainingData(`value`: Output<MLTableJobInputArgs>) {
        this.trainingData = value
    }

    /**
     * @param value Validation data inputs.
     */
    @JvmName("hyjohsnjsdnxhbgd")
    public suspend fun validationData(`value`: Output<MLTableJobInputArgs>) {
        this.validationData = value
    }

    /**
     * @param value The fraction of training dataset that needs to be set aside for validation purpose.
     * Values between (0.0 , 1.0)
     * Applied when validation dataset is not provided.
     */
    @JvmName("fymdycpmmjygsnat")
    public suspend fun validationDataSize(`value`: Output<Double>) {
        this.validationDataSize = value
    }

    /**
     * @param value [Required] Limit settings for the AutoML job.
     */
    @JvmName("wdbtnnsbcoobfuuo")
    public suspend fun limitSettings(`value`: ImageLimitSettingsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.limitSettings = mapped
    }

    /**
     * @param argument [Required] Limit settings for the AutoML job.
     */
    @JvmName("qwtvjfewmqwcnkgy")
    public suspend fun limitSettings(argument: suspend ImageLimitSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = ImageLimitSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.limitSettings = mapped
    }

    /**
     * @param value Log verbosity for the job.
     */
    @JvmName("vnwrerlptxejxief")
    public suspend fun logVerbosity(`value`: Either<String, LogVerbosity>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logVerbosity = mapped
    }

    /**
     * @param value Log verbosity for the job.
     */
    @JvmName("kiguploiapdomrqu")
    public fun logVerbosity(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LogVerbosity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logVerbosity = mapped
    }

    /**
     * @param value Log verbosity for the job.
     */
    @JvmName("xdvktdkgjwtupdjj")
    public fun logVerbosity(`value`: LogVerbosity) {
        val toBeMapped = Either.ofRight<String, LogVerbosity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logVerbosity = mapped
    }

    /**
     * @param value Settings used for training the model.
     */
    @JvmName("ujerdktesdrhdjeb")
    public suspend fun modelSettings(`value`: ImageModelSettingsClassificationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modelSettings = mapped
    }

    /**
     * @param argument Settings used for training the model.
     */
    @JvmName("rpxnwmeswvvokles")
    public suspend fun modelSettings(argument: suspend ImageModelSettingsClassificationArgsBuilder.() -> Unit) {
        val toBeMapped = ImageModelSettingsClassificationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.modelSettings = mapped
    }

    /**
     * @param value Primary metric to optimize for this task.
     */
    @JvmName("tgftjjdtfagsomxd")
    public suspend fun primaryMetric(`value`: Either<String, ClassificationMultilabelPrimaryMetrics>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryMetric = mapped
    }

    /**
     * @param value Primary metric to optimize for this task.
     */
    @JvmName("qgipxvrydboxkgct")
    public fun primaryMetric(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ClassificationMultilabelPrimaryMetrics>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.primaryMetric = mapped
    }

    /**
     * @param value Primary metric to optimize for this task.
     */
    @JvmName("rvrkdbstgejvtmar")
    public fun primaryMetric(`value`: ClassificationMultilabelPrimaryMetrics) {
        val toBeMapped = Either.ofRight<String, ClassificationMultilabelPrimaryMetrics>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.primaryMetric = mapped
    }

    /**
     * @param value Search space for sampling different combinations of models and their hyperparameters.
     */
    @JvmName("mkkcgxtekunfwgqf")
    public suspend fun searchSpace(`value`: List<ImageModelDistributionSettingsClassificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.searchSpace = mapped
    }

    /**
     * @param argument Search space for sampling different combinations of models and their hyperparameters.
     */
    @JvmName("kkyaqxguyjxsugom")
    public suspend fun searchSpace(argument: List<suspend ImageModelDistributionSettingsClassificationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ImageModelDistributionSettingsClassificationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.searchSpace = mapped
    }

    /**
     * @param argument Search space for sampling different combinations of models and their hyperparameters.
     */
    @JvmName("qmlyqnnwnhgopfeu")
    public suspend fun searchSpace(vararg argument: suspend ImageModelDistributionSettingsClassificationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ImageModelDistributionSettingsClassificationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.searchSpace = mapped
    }

    /**
     * @param argument Search space for sampling different combinations of models and their hyperparameters.
     */
    @JvmName("teesjxrwbiucetxq")
    public suspend fun searchSpace(argument: suspend ImageModelDistributionSettingsClassificationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ImageModelDistributionSettingsClassificationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.searchSpace = mapped
    }

    /**
     * @param values Search space for sampling different combinations of models and their hyperparameters.
     */
    @JvmName("vrchjlwxhlhtmdwo")
    public suspend fun searchSpace(vararg values: ImageModelDistributionSettingsClassificationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.searchSpace = mapped
    }

    /**
     * @param value Model sweeping and hyperparameter sweeping related settings.
     */
    @JvmName("iirwxhfetpydxslc")
    public suspend fun sweepSettings(`value`: ImageSweepSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sweepSettings = mapped
    }

    /**
     * @param argument Model sweeping and hyperparameter sweeping related settings.
     */
    @JvmName("xeuearrjiwmbuxrj")
    public suspend fun sweepSettings(argument: suspend ImageSweepSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = ImageSweepSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sweepSettings = mapped
    }

    /**
     * @param value Target column name: This is prediction values column.
     * Also known as label column name in context of classification tasks.
     */
    @JvmName("bnqswdnayakpnxxh")
    public suspend fun targetColumnName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetColumnName = mapped
    }

    /**
     * @param value AutoMLJob Task type.
     * Expected value is 'ImageClassificationMultilabel'.
     */
    @JvmName("slnvxpnrjkwshhgi")
    public suspend fun taskType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.taskType = mapped
    }

    /**
     * @param value [Required] Training data input.
     */
    @JvmName("mhugdfpaggfpwhbx")
    public suspend fun trainingData(`value`: MLTableJobInputArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trainingData = mapped
    }

    /**
     * @param argument [Required] Training data input.
     */
    @JvmName("dryjkmltiwrndqrx")
    public suspend fun trainingData(argument: suspend MLTableJobInputArgsBuilder.() -> Unit) {
        val toBeMapped = MLTableJobInputArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.trainingData = mapped
    }

    /**
     * @param value Validation data inputs.
     */
    @JvmName("fkkcnyranlufpgde")
    public suspend fun validationData(`value`: MLTableJobInputArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validationData = mapped
    }

    /**
     * @param argument Validation data inputs.
     */
    @JvmName("ynnikhmhxngiumxw")
    public suspend fun validationData(argument: suspend MLTableJobInputArgsBuilder.() -> Unit) {
        val toBeMapped = MLTableJobInputArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.validationData = mapped
    }

    /**
     * @param value The fraction of training dataset that needs to be set aside for validation purpose.
     * Values between (0.0 , 1.0)
     * Applied when validation dataset is not provided.
     */
    @JvmName("jsjppioknxpsralf")
    public suspend fun validationDataSize(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validationDataSize = mapped
    }

    internal fun build(): ImageClassificationMultilabelArgs = ImageClassificationMultilabelArgs(
        limitSettings = limitSettings ?: throw PulumiNullFieldException("limitSettings"),
        logVerbosity = logVerbosity,
        modelSettings = modelSettings,
        primaryMetric = primaryMetric,
        searchSpace = searchSpace,
        sweepSettings = sweepSettings,
        targetColumnName = targetColumnName,
        taskType = taskType ?: throw PulumiNullFieldException("taskType"),
        trainingData = trainingData ?: throw PulumiNullFieldException("trainingData"),
        validationData = validationData,
        validationDataSize = validationDataSize,
    )
}
