@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.ImageModelDistributionSettingsObjectDetectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Distribution expressions to sweep over values of model settings.
 * <example>
 * Some examples are:
 * ```
 * ModelName = "choice('seresnext', 'resnest50')";
 * LearningRate = "uniform(0.001, 0.01)";
 * LayersToFreeze = "choice(0, 2)";
 * ```</example>
 * For more details on how to compose distribution expressions please check the documentation:
 * https://docs.microsoft.com/en-us/azure/machine-learning/how-to-tune-hyperparameters
 * For more information on the available settings please visit the official documentation:
 * https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
 * @property amsGradient Enable AMSGrad when optimizer is 'adam' or 'adamw'.
 * @property augmentations Settings for using Augmentations.
 * @property beta1 Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
 * @property beta2 Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
 * @property boxDetectionsPerImage Maximum number of detections per image, for all classes. Must be a positive integer.
 * Note: This settings is not supported for the 'yolov5' algorithm.
 * @property boxScoreThreshold During inference, only return proposals with a classification score greater than
 * BoxScoreThreshold. Must be a float in the range[0, 1].
 * @property distributed Whether to use distributer training.
 * @property earlyStopping Enable early stopping logic during training.
 * @property earlyStoppingDelay Minimum number of epochs or validation evaluations to wait before primary metric improvement
 * is tracked for early stopping. Must be a positive integer.
 * @property earlyStoppingPatience Minimum number of epochs or validation evaluations with no primary metric improvement before
 * the run is stopped. Must be a positive integer.
 * @property enableOnnxNormalization Enable normalization when exporting ONNX model.
 * @property evaluationFrequency Frequency to evaluate validation dataset to get metric scores. Must be a positive integer.
 * @property gradientAccumulationStep Gradient accumulation means running a configured number of "GradAccumulationStep" steps without
 * updating the model weights while accumulating the gradients of those steps, and then using
 * the accumulated gradients to compute the weight updates. Must be a positive integer.
 * @property imageSize Image size for train and validation. Must be a positive integer.
 * Note: The training run may get into CUDA OOM if the size is too big.
 * Note: This settings is only supported for the 'yolov5' algorithm.
 * @property layersToFreeze Number of layers to freeze for the model. Must be a positive integer.
 * For instance, passing 2 as value for 'seresnext' means
 * freezing layer0 and layer1. For a full list of models supported and details on layer freeze, please
 * see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
 * @property learningRate Initial learning rate. Must be a float in the range [0, 1].
 * @property learningRateScheduler Type of learning rate scheduler. Must be 'warmup_cosine' or 'step'.
 * @property maxSize Maximum size of the image to be rescaled before feeding it to the backbone.
 * Must be a positive integer. Note: training run may get into CUDA OOM if the size is too big.
 * Note: This settings is not supported for the 'yolov5' algorithm.
 * @property minSize Minimum size of the image to be rescaled before feeding it to the backbone.
 * Must be a positive integer. Note: training run may get into CUDA OOM if the size is too big.
 * Note: This settings is not supported for the 'yolov5' algorithm.
 * @property modelName Name of the model to use for training.
 * For more information on the available models please visit the official documentation:
 * https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
 * @property modelSize Model size. Must be 'small', 'medium', 'large', or 'xlarge'.
 * Note: training run may get into CUDA OOM if the model size is too big.
 * Note: This settings is only supported for the 'yolov5' algorithm.
 * @property momentum Value of momentum when optimizer is 'sgd'. Must be a float in the range [0, 1].
 * @property multiScale Enable multi-scale image by varying image size by +/- 50%.
 * Note: training run may get into CUDA OOM if no sufficient GPU memory.
 * Note: This settings is only supported for the 'yolov5' algorithm.
 * @property nesterov Enable nesterov when optimizer is 'sgd'.
 * @property nmsIouThreshold IOU threshold used during inference in NMS post processing. Must be float in the range [0, 1].
 * @property numberOfEpochs Number of training epochs. Must be a positive integer.
 * @property numberOfWorkers Number of data loader workers. Must be a non-negative integer.
 * @property optimizer Type of optimizer. Must be either 'sgd', 'adam', or 'adamw'.
 * @property randomSeed Random seed to be used when using deterministic training.
 * @property stepLRGamma Value of gamma when learning rate scheduler is 'step'. Must be a float in the range [0, 1].
 * @property stepLRStepSize Value of step size when learning rate scheduler is 'step'. Must be a positive integer.
 * @property tileGridSize The grid size to use for tiling each image. Note: TileGridSize must not be
 * None to enable small object detection logic. A string containing two integers in mxn format.
 * Note: This settings is not supported for the 'yolov5' algorithm.
 * @property tileOverlapRatio Overlap ratio between adjacent tiles in each dimension. Must be float in the range [0, 1).
 * Note: This settings is not supported for the 'yolov5' algorithm.
 * @property tilePredictionsNmsThreshold The IOU threshold to use to perform NMS while merging predictions from tiles and image.
 * Used in validation/ inference. Must be float in the range [0, 1].
 * Note: This settings is not supported for the 'yolov5' algorithm.
 * NMS: Non-maximum suppression
 * @property trainingBatchSize Training batch size. Must be a positive integer.
 * @property validationBatchSize Validation batch size. Must be a positive integer.
 * @property validationIouThreshold IOU threshold to use when computing validation metric. Must be float in the range [0, 1].
 * @property validationMetricType Metric computation method to use for validation metrics. Must be 'none', 'coco', 'voc', or 'coco_voc'.
 * @property warmupCosineLRCycles Value of cosine cycle when learning rate scheduler is 'warmup_cosine'. Must be a float in the range [0, 1].
 * @property warmupCosineLRWarmupEpochs Value of warmup epochs when learning rate scheduler is 'warmup_cosine'. Must be a positive integer.
 * @property weightDecay Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must be a float in the range[0, 1].
 */
public data class ImageModelDistributionSettingsObjectDetectionArgs(
    public val amsGradient: Output<String>? = null,
    public val augmentations: Output<String>? = null,
    public val beta1: Output<String>? = null,
    public val beta2: Output<String>? = null,
    public val boxDetectionsPerImage: Output<String>? = null,
    public val boxScoreThreshold: Output<String>? = null,
    public val distributed: Output<String>? = null,
    public val earlyStopping: Output<String>? = null,
    public val earlyStoppingDelay: Output<String>? = null,
    public val earlyStoppingPatience: Output<String>? = null,
    public val enableOnnxNormalization: Output<String>? = null,
    public val evaluationFrequency: Output<String>? = null,
    public val gradientAccumulationStep: Output<String>? = null,
    public val imageSize: Output<String>? = null,
    public val layersToFreeze: Output<String>? = null,
    public val learningRate: Output<String>? = null,
    public val learningRateScheduler: Output<String>? = null,
    public val maxSize: Output<String>? = null,
    public val minSize: Output<String>? = null,
    public val modelName: Output<String>? = null,
    public val modelSize: Output<String>? = null,
    public val momentum: Output<String>? = null,
    public val multiScale: Output<String>? = null,
    public val nesterov: Output<String>? = null,
    public val nmsIouThreshold: Output<String>? = null,
    public val numberOfEpochs: Output<String>? = null,
    public val numberOfWorkers: Output<String>? = null,
    public val optimizer: Output<String>? = null,
    public val randomSeed: Output<String>? = null,
    public val stepLRGamma: Output<String>? = null,
    public val stepLRStepSize: Output<String>? = null,
    public val tileGridSize: Output<String>? = null,
    public val tileOverlapRatio: Output<String>? = null,
    public val tilePredictionsNmsThreshold: Output<String>? = null,
    public val trainingBatchSize: Output<String>? = null,
    public val validationBatchSize: Output<String>? = null,
    public val validationIouThreshold: Output<String>? = null,
    public val validationMetricType: Output<String>? = null,
    public val warmupCosineLRCycles: Output<String>? = null,
    public val warmupCosineLRWarmupEpochs: Output<String>? = null,
    public val weightDecay: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.ImageModelDistributionSettingsObjectDetectionArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.ImageModelDistributionSettingsObjectDetectionArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.ImageModelDistributionSettingsObjectDetectionArgs.builder()
            .amsGradient(amsGradient?.applyValue({ args0 -> args0 }))
            .augmentations(augmentations?.applyValue({ args0 -> args0 }))
            .beta1(beta1?.applyValue({ args0 -> args0 }))
            .beta2(beta2?.applyValue({ args0 -> args0 }))
            .boxDetectionsPerImage(boxDetectionsPerImage?.applyValue({ args0 -> args0 }))
            .boxScoreThreshold(boxScoreThreshold?.applyValue({ args0 -> args0 }))
            .distributed(distributed?.applyValue({ args0 -> args0 }))
            .earlyStopping(earlyStopping?.applyValue({ args0 -> args0 }))
            .earlyStoppingDelay(earlyStoppingDelay?.applyValue({ args0 -> args0 }))
            .earlyStoppingPatience(earlyStoppingPatience?.applyValue({ args0 -> args0 }))
            .enableOnnxNormalization(enableOnnxNormalization?.applyValue({ args0 -> args0 }))
            .evaluationFrequency(evaluationFrequency?.applyValue({ args0 -> args0 }))
            .gradientAccumulationStep(gradientAccumulationStep?.applyValue({ args0 -> args0 }))
            .imageSize(imageSize?.applyValue({ args0 -> args0 }))
            .layersToFreeze(layersToFreeze?.applyValue({ args0 -> args0 }))
            .learningRate(learningRate?.applyValue({ args0 -> args0 }))
            .learningRateScheduler(learningRateScheduler?.applyValue({ args0 -> args0 }))
            .maxSize(maxSize?.applyValue({ args0 -> args0 }))
            .minSize(minSize?.applyValue({ args0 -> args0 }))
            .modelName(modelName?.applyValue({ args0 -> args0 }))
            .modelSize(modelSize?.applyValue({ args0 -> args0 }))
            .momentum(momentum?.applyValue({ args0 -> args0 }))
            .multiScale(multiScale?.applyValue({ args0 -> args0 }))
            .nesterov(nesterov?.applyValue({ args0 -> args0 }))
            .nmsIouThreshold(nmsIouThreshold?.applyValue({ args0 -> args0 }))
            .numberOfEpochs(numberOfEpochs?.applyValue({ args0 -> args0 }))
            .numberOfWorkers(numberOfWorkers?.applyValue({ args0 -> args0 }))
            .optimizer(optimizer?.applyValue({ args0 -> args0 }))
            .randomSeed(randomSeed?.applyValue({ args0 -> args0 }))
            .stepLRGamma(stepLRGamma?.applyValue({ args0 -> args0 }))
            .stepLRStepSize(stepLRStepSize?.applyValue({ args0 -> args0 }))
            .tileGridSize(tileGridSize?.applyValue({ args0 -> args0 }))
            .tileOverlapRatio(tileOverlapRatio?.applyValue({ args0 -> args0 }))
            .tilePredictionsNmsThreshold(tilePredictionsNmsThreshold?.applyValue({ args0 -> args0 }))
            .trainingBatchSize(trainingBatchSize?.applyValue({ args0 -> args0 }))
            .validationBatchSize(validationBatchSize?.applyValue({ args0 -> args0 }))
            .validationIouThreshold(validationIouThreshold?.applyValue({ args0 -> args0 }))
            .validationMetricType(validationMetricType?.applyValue({ args0 -> args0 }))
            .warmupCosineLRCycles(warmupCosineLRCycles?.applyValue({ args0 -> args0 }))
            .warmupCosineLRWarmupEpochs(warmupCosineLRWarmupEpochs?.applyValue({ args0 -> args0 }))
            .weightDecay(weightDecay?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImageModelDistributionSettingsObjectDetectionArgs].
 */
@PulumiTagMarker
public class ImageModelDistributionSettingsObjectDetectionArgsBuilder internal constructor() {
    private var amsGradient: Output<String>? = null

    private var augmentations: Output<String>? = null

    private var beta1: Output<String>? = null

    private var beta2: Output<String>? = null

    private var boxDetectionsPerImage: Output<String>? = null

    private var boxScoreThreshold: Output<String>? = null

    private var distributed: Output<String>? = null

    private var earlyStopping: Output<String>? = null

    private var earlyStoppingDelay: Output<String>? = null

    private var earlyStoppingPatience: Output<String>? = null

    private var enableOnnxNormalization: Output<String>? = null

    private var evaluationFrequency: Output<String>? = null

    private var gradientAccumulationStep: Output<String>? = null

    private var imageSize: Output<String>? = null

    private var layersToFreeze: Output<String>? = null

    private var learningRate: Output<String>? = null

    private var learningRateScheduler: Output<String>? = null

    private var maxSize: Output<String>? = null

    private var minSize: Output<String>? = null

    private var modelName: Output<String>? = null

    private var modelSize: Output<String>? = null

    private var momentum: Output<String>? = null

    private var multiScale: Output<String>? = null

    private var nesterov: Output<String>? = null

    private var nmsIouThreshold: Output<String>? = null

    private var numberOfEpochs: Output<String>? = null

    private var numberOfWorkers: Output<String>? = null

    private var optimizer: Output<String>? = null

    private var randomSeed: Output<String>? = null

    private var stepLRGamma: Output<String>? = null

    private var stepLRStepSize: Output<String>? = null

    private var tileGridSize: Output<String>? = null

    private var tileOverlapRatio: Output<String>? = null

    private var tilePredictionsNmsThreshold: Output<String>? = null

    private var trainingBatchSize: Output<String>? = null

    private var validationBatchSize: Output<String>? = null

    private var validationIouThreshold: Output<String>? = null

    private var validationMetricType: Output<String>? = null

    private var warmupCosineLRCycles: Output<String>? = null

    private var warmupCosineLRWarmupEpochs: Output<String>? = null

    private var weightDecay: Output<String>? = null

    /**
     * @param value Enable AMSGrad when optimizer is 'adam' or 'adamw'.
     */
    @JvmName("frnyqaykyhkcpggt")
    public suspend fun amsGradient(`value`: Output<String>) {
        this.amsGradient = value
    }

    /**
     * @param value Settings for using Augmentations.
     */
    @JvmName("mnmyonqfolypdjsl")
    public suspend fun augmentations(`value`: Output<String>) {
        this.augmentations = value
    }

    /**
     * @param value Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
     */
    @JvmName("arllykjkmafsfrjl")
    public suspend fun beta1(`value`: Output<String>) {
        this.beta1 = value
    }

    /**
     * @param value Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
     */
    @JvmName("uqyhmlewrwwvwdlx")
    public suspend fun beta2(`value`: Output<String>) {
        this.beta2 = value
    }

    /**
     * @param value Maximum number of detections per image, for all classes. Must be a positive integer.
     * Note: This settings is not supported for the 'yolov5' algorithm.
     */
    @JvmName("lnvlgfsmuaisxnmk")
    public suspend fun boxDetectionsPerImage(`value`: Output<String>) {
        this.boxDetectionsPerImage = value
    }

    /**
     * @param value During inference, only return proposals with a classification score greater than
     * BoxScoreThreshold. Must be a float in the range[0, 1].
     */
    @JvmName("mxsuccvguvshtcpi")
    public suspend fun boxScoreThreshold(`value`: Output<String>) {
        this.boxScoreThreshold = value
    }

    /**
     * @param value Whether to use distributer training.
     */
    @JvmName("ulhemibbvjocuemv")
    public suspend fun distributed(`value`: Output<String>) {
        this.distributed = value
    }

    /**
     * @param value Enable early stopping logic during training.
     */
    @JvmName("glbxvxidcqwnwkhg")
    public suspend fun earlyStopping(`value`: Output<String>) {
        this.earlyStopping = value
    }

    /**
     * @param value Minimum number of epochs or validation evaluations to wait before primary metric improvement
     * is tracked for early stopping. Must be a positive integer.
     */
    @JvmName("jnbblddbjvetdqbo")
    public suspend fun earlyStoppingDelay(`value`: Output<String>) {
        this.earlyStoppingDelay = value
    }

    /**
     * @param value Minimum number of epochs or validation evaluations with no primary metric improvement before
     * the run is stopped. Must be a positive integer.
     */
    @JvmName("cocjfxrkqnemimns")
    public suspend fun earlyStoppingPatience(`value`: Output<String>) {
        this.earlyStoppingPatience = value
    }

    /**
     * @param value Enable normalization when exporting ONNX model.
     */
    @JvmName("bfxtectettsxvyoi")
    public suspend fun enableOnnxNormalization(`value`: Output<String>) {
        this.enableOnnxNormalization = value
    }

    /**
     * @param value Frequency to evaluate validation dataset to get metric scores. Must be a positive integer.
     */
    @JvmName("cnnbuaxabwptnjen")
    public suspend fun evaluationFrequency(`value`: Output<String>) {
        this.evaluationFrequency = value
    }

    /**
     * @param value Gradient accumulation means running a configured number of "GradAccumulationStep" steps without
     * updating the model weights while accumulating the gradients of those steps, and then using
     * the accumulated gradients to compute the weight updates. Must be a positive integer.
     */
    @JvmName("bqyfirokwnuhyojk")
    public suspend fun gradientAccumulationStep(`value`: Output<String>) {
        this.gradientAccumulationStep = value
    }

    /**
     * @param value Image size for train and validation. Must be a positive integer.
     * Note: The training run may get into CUDA OOM if the size is too big.
     * Note: This settings is only supported for the 'yolov5' algorithm.
     */
    @JvmName("gdmglnnabtbqqiaj")
    public suspend fun imageSize(`value`: Output<String>) {
        this.imageSize = value
    }

    /**
     * @param value Number of layers to freeze for the model. Must be a positive integer.
     * For instance, passing 2 as value for 'seresnext' means
     * freezing layer0 and layer1. For a full list of models supported and details on layer freeze, please
     * see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
     */
    @JvmName("pyadksffgdyklbmo")
    public suspend fun layersToFreeze(`value`: Output<String>) {
        this.layersToFreeze = value
    }

    /**
     * @param value Initial learning rate. Must be a float in the range [0, 1].
     */
    @JvmName("wffdcsvumhxfmtxx")
    public suspend fun learningRate(`value`: Output<String>) {
        this.learningRate = value
    }

    /**
     * @param value Type of learning rate scheduler. Must be 'warmup_cosine' or 'step'.
     */
    @JvmName("jmiihpmqgaixgsmc")
    public suspend fun learningRateScheduler(`value`: Output<String>) {
        this.learningRateScheduler = value
    }

    /**
     * @param value Maximum size of the image to be rescaled before feeding it to the backbone.
     * Must be a positive integer. Note: training run may get into CUDA OOM if the size is too big.
     * Note: This settings is not supported for the 'yolov5' algorithm.
     */
    @JvmName("lerkcdpfwjilcdma")
    public suspend fun maxSize(`value`: Output<String>) {
        this.maxSize = value
    }

    /**
     * @param value Minimum size of the image to be rescaled before feeding it to the backbone.
     * Must be a positive integer. Note: training run may get into CUDA OOM if the size is too big.
     * Note: This settings is not supported for the 'yolov5' algorithm.
     */
    @JvmName("anknysbnxjopdebq")
    public suspend fun minSize(`value`: Output<String>) {
        this.minSize = value
    }

    /**
     * @param value Name of the model to use for training.
     * For more information on the available models please visit the official documentation:
     * https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
     */
    @JvmName("poldljddebtevgnl")
    public suspend fun modelName(`value`: Output<String>) {
        this.modelName = value
    }

    /**
     * @param value Model size. Must be 'small', 'medium', 'large', or 'xlarge'.
     * Note: training run may get into CUDA OOM if the model size is too big.
     * Note: This settings is only supported for the 'yolov5' algorithm.
     */
    @JvmName("nhnalxedwhvcjkpf")
    public suspend fun modelSize(`value`: Output<String>) {
        this.modelSize = value
    }

    /**
     * @param value Value of momentum when optimizer is 'sgd'. Must be a float in the range [0, 1].
     */
    @JvmName("fgtqvuahbpqoymhr")
    public suspend fun momentum(`value`: Output<String>) {
        this.momentum = value
    }

    /**
     * @param value Enable multi-scale image by varying image size by +/- 50%.
     * Note: training run may get into CUDA OOM if no sufficient GPU memory.
     * Note: This settings is only supported for the 'yolov5' algorithm.
     */
    @JvmName("oqpvqqyxbrnlydxl")
    public suspend fun multiScale(`value`: Output<String>) {
        this.multiScale = value
    }

    /**
     * @param value Enable nesterov when optimizer is 'sgd'.
     */
    @JvmName("epjbyqqhdrwembpd")
    public suspend fun nesterov(`value`: Output<String>) {
        this.nesterov = value
    }

    /**
     * @param value IOU threshold used during inference in NMS post processing. Must be float in the range [0, 1].
     */
    @JvmName("ikakkxnbhrxwphkn")
    public suspend fun nmsIouThreshold(`value`: Output<String>) {
        this.nmsIouThreshold = value
    }

    /**
     * @param value Number of training epochs. Must be a positive integer.
     */
    @JvmName("cyffhkswgqkmalcv")
    public suspend fun numberOfEpochs(`value`: Output<String>) {
        this.numberOfEpochs = value
    }

    /**
     * @param value Number of data loader workers. Must be a non-negative integer.
     */
    @JvmName("yywjorancwnecfjj")
    public suspend fun numberOfWorkers(`value`: Output<String>) {
        this.numberOfWorkers = value
    }

    /**
     * @param value Type of optimizer. Must be either 'sgd', 'adam', or 'adamw'.
     */
    @JvmName("ynpayanofupamppv")
    public suspend fun optimizer(`value`: Output<String>) {
        this.optimizer = value
    }

    /**
     * @param value Random seed to be used when using deterministic training.
     */
    @JvmName("tmaiiukvxpjdnlek")
    public suspend fun randomSeed(`value`: Output<String>) {
        this.randomSeed = value
    }

    /**
     * @param value Value of gamma when learning rate scheduler is 'step'. Must be a float in the range [0, 1].
     */
    @JvmName("nsmjgffhwdnfbrwr")
    public suspend fun stepLRGamma(`value`: Output<String>) {
        this.stepLRGamma = value
    }

    /**
     * @param value Value of step size when learning rate scheduler is 'step'. Must be a positive integer.
     */
    @JvmName("iehctqulgietavba")
    public suspend fun stepLRStepSize(`value`: Output<String>) {
        this.stepLRStepSize = value
    }

    /**
     * @param value The grid size to use for tiling each image. Note: TileGridSize must not be
     * None to enable small object detection logic. A string containing two integers in mxn format.
     * Note: This settings is not supported for the 'yolov5' algorithm.
     */
    @JvmName("sfbkgficjwvrttpn")
    public suspend fun tileGridSize(`value`: Output<String>) {
        this.tileGridSize = value
    }

    /**
     * @param value Overlap ratio between adjacent tiles in each dimension. Must be float in the range [0, 1).
     * Note: This settings is not supported for the 'yolov5' algorithm.
     */
    @JvmName("tpviytbtycmfsumb")
    public suspend fun tileOverlapRatio(`value`: Output<String>) {
        this.tileOverlapRatio = value
    }

    /**
     * @param value The IOU threshold to use to perform NMS while merging predictions from tiles and image.
     * Used in validation/ inference. Must be float in the range [0, 1].
     * Note: This settings is not supported for the 'yolov5' algorithm.
     * NMS: Non-maximum suppression
     */
    @JvmName("cklgvmkuddocajus")
    public suspend fun tilePredictionsNmsThreshold(`value`: Output<String>) {
        this.tilePredictionsNmsThreshold = value
    }

    /**
     * @param value Training batch size. Must be a positive integer.
     */
    @JvmName("relcslrvgnoikycn")
    public suspend fun trainingBatchSize(`value`: Output<String>) {
        this.trainingBatchSize = value
    }

    /**
     * @param value Validation batch size. Must be a positive integer.
     */
    @JvmName("tekkajqmtfyihqye")
    public suspend fun validationBatchSize(`value`: Output<String>) {
        this.validationBatchSize = value
    }

    /**
     * @param value IOU threshold to use when computing validation metric. Must be float in the range [0, 1].
     */
    @JvmName("faujsmevadeirdie")
    public suspend fun validationIouThreshold(`value`: Output<String>) {
        this.validationIouThreshold = value
    }

    /**
     * @param value Metric computation method to use for validation metrics. Must be 'none', 'coco', 'voc', or 'coco_voc'.
     */
    @JvmName("pworleblbetsskxg")
    public suspend fun validationMetricType(`value`: Output<String>) {
        this.validationMetricType = value
    }

    /**
     * @param value Value of cosine cycle when learning rate scheduler is 'warmup_cosine'. Must be a float in the range [0, 1].
     */
    @JvmName("xftflkunqixlbwoe")
    public suspend fun warmupCosineLRCycles(`value`: Output<String>) {
        this.warmupCosineLRCycles = value
    }

    /**
     * @param value Value of warmup epochs when learning rate scheduler is 'warmup_cosine'. Must be a positive integer.
     */
    @JvmName("jlujdgrfuurpgoxe")
    public suspend fun warmupCosineLRWarmupEpochs(`value`: Output<String>) {
        this.warmupCosineLRWarmupEpochs = value
    }

    /**
     * @param value Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must be a float in the range[0, 1].
     */
    @JvmName("loehpwvyxorkfili")
    public suspend fun weightDecay(`value`: Output<String>) {
        this.weightDecay = value
    }

    /**
     * @param value Enable AMSGrad when optimizer is 'adam' or 'adamw'.
     */
    @JvmName("bqbdussadgbalxyo")
    public suspend fun amsGradient(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.amsGradient = mapped
    }

    /**
     * @param value Settings for using Augmentations.
     */
    @JvmName("jbvpquvwivkagsyv")
    public suspend fun augmentations(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.augmentations = mapped
    }

    /**
     * @param value Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
     */
    @JvmName("hgqhekhkcugttteq")
    public suspend fun beta1(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.beta1 = mapped
    }

    /**
     * @param value Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
     */
    @JvmName("dyfxnwkdhpqayemr")
    public suspend fun beta2(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.beta2 = mapped
    }

    /**
     * @param value Maximum number of detections per image, for all classes. Must be a positive integer.
     * Note: This settings is not supported for the 'yolov5' algorithm.
     */
    @JvmName("xfmaavdfjnpbffyg")
    public suspend fun boxDetectionsPerImage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.boxDetectionsPerImage = mapped
    }

    /**
     * @param value During inference, only return proposals with a classification score greater than
     * BoxScoreThreshold. Must be a float in the range[0, 1].
     */
    @JvmName("mlvaenrvmtjwqali")
    public suspend fun boxScoreThreshold(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.boxScoreThreshold = mapped
    }

    /**
     * @param value Whether to use distributer training.
     */
    @JvmName("mqefkdsfcnqbxyey")
    public suspend fun distributed(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.distributed = mapped
    }

    /**
     * @param value Enable early stopping logic during training.
     */
    @JvmName("bqvacjeyntvgtmab")
    public suspend fun earlyStopping(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.earlyStopping = mapped
    }

    /**
     * @param value Minimum number of epochs or validation evaluations to wait before primary metric improvement
     * is tracked for early stopping. Must be a positive integer.
     */
    @JvmName("lshxkfwvwybaqjfi")
    public suspend fun earlyStoppingDelay(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.earlyStoppingDelay = mapped
    }

    /**
     * @param value Minimum number of epochs or validation evaluations with no primary metric improvement before
     * the run is stopped. Must be a positive integer.
     */
    @JvmName("cphpnjvndosodqvx")
    public suspend fun earlyStoppingPatience(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.earlyStoppingPatience = mapped
    }

    /**
     * @param value Enable normalization when exporting ONNX model.
     */
    @JvmName("thgcjduccfxdagpl")
    public suspend fun enableOnnxNormalization(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableOnnxNormalization = mapped
    }

    /**
     * @param value Frequency to evaluate validation dataset to get metric scores. Must be a positive integer.
     */
    @JvmName("gorjhkmqilpnhqjy")
    public suspend fun evaluationFrequency(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.evaluationFrequency = mapped
    }

    /**
     * @param value Gradient accumulation means running a configured number of "GradAccumulationStep" steps without
     * updating the model weights while accumulating the gradients of those steps, and then using
     * the accumulated gradients to compute the weight updates. Must be a positive integer.
     */
    @JvmName("yjnxrvqojlfpxkga")
    public suspend fun gradientAccumulationStep(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gradientAccumulationStep = mapped
    }

    /**
     * @param value Image size for train and validation. Must be a positive integer.
     * Note: The training run may get into CUDA OOM if the size is too big.
     * Note: This settings is only supported for the 'yolov5' algorithm.
     */
    @JvmName("ycsuiycycgufrwxy")
    public suspend fun imageSize(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageSize = mapped
    }

    /**
     * @param value Number of layers to freeze for the model. Must be a positive integer.
     * For instance, passing 2 as value for 'seresnext' means
     * freezing layer0 and layer1. For a full list of models supported and details on layer freeze, please
     * see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
     */
    @JvmName("vxjctoaghnsofbyl")
    public suspend fun layersToFreeze(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.layersToFreeze = mapped
    }

    /**
     * @param value Initial learning rate. Must be a float in the range [0, 1].
     */
    @JvmName("ewobtpnoorxpussu")
    public suspend fun learningRate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.learningRate = mapped
    }

    /**
     * @param value Type of learning rate scheduler. Must be 'warmup_cosine' or 'step'.
     */
    @JvmName("flchthwykvdenoyr")
    public suspend fun learningRateScheduler(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.learningRateScheduler = mapped
    }

    /**
     * @param value Maximum size of the image to be rescaled before feeding it to the backbone.
     * Must be a positive integer. Note: training run may get into CUDA OOM if the size is too big.
     * Note: This settings is not supported for the 'yolov5' algorithm.
     */
    @JvmName("umlunlkafhlonpnq")
    public suspend fun maxSize(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxSize = mapped
    }

    /**
     * @param value Minimum size of the image to be rescaled before feeding it to the backbone.
     * Must be a positive integer. Note: training run may get into CUDA OOM if the size is too big.
     * Note: This settings is not supported for the 'yolov5' algorithm.
     */
    @JvmName("onktgxpncdyciwqb")
    public suspend fun minSize(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minSize = mapped
    }

    /**
     * @param value Name of the model to use for training.
     * For more information on the available models please visit the official documentation:
     * https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
     */
    @JvmName("tyaouoviaumcweef")
    public suspend fun modelName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modelName = mapped
    }

    /**
     * @param value Model size. Must be 'small', 'medium', 'large', or 'xlarge'.
     * Note: training run may get into CUDA OOM if the model size is too big.
     * Note: This settings is only supported for the 'yolov5' algorithm.
     */
    @JvmName("kgihealntcsefhfc")
    public suspend fun modelSize(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modelSize = mapped
    }

    /**
     * @param value Value of momentum when optimizer is 'sgd'. Must be a float in the range [0, 1].
     */
    @JvmName("gvxgvdlchcpargrm")
    public suspend fun momentum(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.momentum = mapped
    }

    /**
     * @param value Enable multi-scale image by varying image size by +/- 50%.
     * Note: training run may get into CUDA OOM if no sufficient GPU memory.
     * Note: This settings is only supported for the 'yolov5' algorithm.
     */
    @JvmName("ppaluejviyxbsqom")
    public suspend fun multiScale(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.multiScale = mapped
    }

    /**
     * @param value Enable nesterov when optimizer is 'sgd'.
     */
    @JvmName("weevmdjhxlvfqssr")
    public suspend fun nesterov(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nesterov = mapped
    }

    /**
     * @param value IOU threshold used during inference in NMS post processing. Must be float in the range [0, 1].
     */
    @JvmName("yxcbehrxgpediqvn")
    public suspend fun nmsIouThreshold(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nmsIouThreshold = mapped
    }

    /**
     * @param value Number of training epochs. Must be a positive integer.
     */
    @JvmName("utonkuktojwcwcpe")
    public suspend fun numberOfEpochs(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.numberOfEpochs = mapped
    }

    /**
     * @param value Number of data loader workers. Must be a non-negative integer.
     */
    @JvmName("wtrrnokwpfkfcxbt")
    public suspend fun numberOfWorkers(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.numberOfWorkers = mapped
    }

    /**
     * @param value Type of optimizer. Must be either 'sgd', 'adam', or 'adamw'.
     */
    @JvmName("glselflnnsdekrmv")
    public suspend fun optimizer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.optimizer = mapped
    }

    /**
     * @param value Random seed to be used when using deterministic training.
     */
    @JvmName("wmgxylyfwucfirit")
    public suspend fun randomSeed(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.randomSeed = mapped
    }

    /**
     * @param value Value of gamma when learning rate scheduler is 'step'. Must be a float in the range [0, 1].
     */
    @JvmName("rvgrwmajoqxnywla")
    public suspend fun stepLRGamma(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stepLRGamma = mapped
    }

    /**
     * @param value Value of step size when learning rate scheduler is 'step'. Must be a positive integer.
     */
    @JvmName("mqpjyajaemccroat")
    public suspend fun stepLRStepSize(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stepLRStepSize = mapped
    }

    /**
     * @param value The grid size to use for tiling each image. Note: TileGridSize must not be
     * None to enable small object detection logic. A string containing two integers in mxn format.
     * Note: This settings is not supported for the 'yolov5' algorithm.
     */
    @JvmName("qofetfwdofwajtgp")
    public suspend fun tileGridSize(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tileGridSize = mapped
    }

    /**
     * @param value Overlap ratio between adjacent tiles in each dimension. Must be float in the range [0, 1).
     * Note: This settings is not supported for the 'yolov5' algorithm.
     */
    @JvmName("liboypsegwdwaguv")
    public suspend fun tileOverlapRatio(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tileOverlapRatio = mapped
    }

    /**
     * @param value The IOU threshold to use to perform NMS while merging predictions from tiles and image.
     * Used in validation/ inference. Must be float in the range [0, 1].
     * Note: This settings is not supported for the 'yolov5' algorithm.
     * NMS: Non-maximum suppression
     */
    @JvmName("ghypxjvepffmexay")
    public suspend fun tilePredictionsNmsThreshold(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tilePredictionsNmsThreshold = mapped
    }

    /**
     * @param value Training batch size. Must be a positive integer.
     */
    @JvmName("givkllwofrxagrkw")
    public suspend fun trainingBatchSize(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trainingBatchSize = mapped
    }

    /**
     * @param value Validation batch size. Must be a positive integer.
     */
    @JvmName("muqbhyqybgmdebxb")
    public suspend fun validationBatchSize(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validationBatchSize = mapped
    }

    /**
     * @param value IOU threshold to use when computing validation metric. Must be float in the range [0, 1].
     */
    @JvmName("fxxggbuvupfnulxs")
    public suspend fun validationIouThreshold(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validationIouThreshold = mapped
    }

    /**
     * @param value Metric computation method to use for validation metrics. Must be 'none', 'coco', 'voc', or 'coco_voc'.
     */
    @JvmName("bklwlxruaeaaptkt")
    public suspend fun validationMetricType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validationMetricType = mapped
    }

    /**
     * @param value Value of cosine cycle when learning rate scheduler is 'warmup_cosine'. Must be a float in the range [0, 1].
     */
    @JvmName("gjesvgutdhbdoqik")
    public suspend fun warmupCosineLRCycles(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.warmupCosineLRCycles = mapped
    }

    /**
     * @param value Value of warmup epochs when learning rate scheduler is 'warmup_cosine'. Must be a positive integer.
     */
    @JvmName("kogokaqicegqjbiw")
    public suspend fun warmupCosineLRWarmupEpochs(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.warmupCosineLRWarmupEpochs = mapped
    }

    /**
     * @param value Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must be a float in the range[0, 1].
     */
    @JvmName("hxhvrikwphiepite")
    public suspend fun weightDecay(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weightDecay = mapped
    }

    internal fun build(): ImageModelDistributionSettingsObjectDetectionArgs =
        ImageModelDistributionSettingsObjectDetectionArgs(
            amsGradient = amsGradient,
            augmentations = augmentations,
            beta1 = beta1,
            beta2 = beta2,
            boxDetectionsPerImage = boxDetectionsPerImage,
            boxScoreThreshold = boxScoreThreshold,
            distributed = distributed,
            earlyStopping = earlyStopping,
            earlyStoppingDelay = earlyStoppingDelay,
            earlyStoppingPatience = earlyStoppingPatience,
            enableOnnxNormalization = enableOnnxNormalization,
            evaluationFrequency = evaluationFrequency,
            gradientAccumulationStep = gradientAccumulationStep,
            imageSize = imageSize,
            layersToFreeze = layersToFreeze,
            learningRate = learningRate,
            learningRateScheduler = learningRateScheduler,
            maxSize = maxSize,
            minSize = minSize,
            modelName = modelName,
            modelSize = modelSize,
            momentum = momentum,
            multiScale = multiScale,
            nesterov = nesterov,
            nmsIouThreshold = nmsIouThreshold,
            numberOfEpochs = numberOfEpochs,
            numberOfWorkers = numberOfWorkers,
            optimizer = optimizer,
            randomSeed = randomSeed,
            stepLRGamma = stepLRGamma,
            stepLRStepSize = stepLRStepSize,
            tileGridSize = tileGridSize,
            tileOverlapRatio = tileOverlapRatio,
            tilePredictionsNmsThreshold = tilePredictionsNmsThreshold,
            trainingBatchSize = trainingBatchSize,
            validationBatchSize = validationBatchSize,
            validationIouThreshold = validationIouThreshold,
            validationMetricType = validationMetricType,
            warmupCosineLRCycles = warmupCosineLRCycles,
            warmupCosineLRWarmupEpochs = warmupCosineLRWarmupEpochs,
            weightDecay = weightDecay,
        )
}
