@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.ImageObjectDetectionArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.LogVerbosity
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.ObjectDetectionPrimaryMetrics
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Image Object Detection. Object detection is used to identify objects in an image and locate each object with a
 * bounding box e.g. locate all dogs and cats in an image and draw a bounding box around each.
 * @property limitSettings [Required] Limit settings for the AutoML job.
 * @property logVerbosity Log verbosity for the job.
 * @property modelSettings Settings used for training the model.
 * @property primaryMetric Primary metric to optimize for this task.
 * @property searchSpace Search space for sampling different combinations of models and their hyperparameters.
 * @property sweepSettings Model sweeping and hyperparameter sweeping related settings.
 * @property targetColumnName Target column name: This is prediction values column.
 * Also known as label column name in context of classification tasks.
 * @property taskType AutoMLJob Task type.
 * Expected value is 'ImageObjectDetection'.
 * @property trainingData [Required] Training data input.
 * @property validationData Validation data inputs.
 * @property validationDataSize The fraction of training dataset that needs to be set aside for validation purpose.
 * Values between (0.0 , 1.0)
 * Applied when validation dataset is not provided.
 */
public data class ImageObjectDetectionArgs(
    public val limitSettings: Output<ImageLimitSettingsArgs>,
    public val logVerbosity: Output<Either<String, LogVerbosity>>? = null,
    public val modelSettings: Output<ImageModelSettingsObjectDetectionArgs>? = null,
    public val primaryMetric: Output<Either<String, ObjectDetectionPrimaryMetrics>>? = null,
    public val searchSpace: Output<List<ImageModelDistributionSettingsObjectDetectionArgs>>? = null,
    public val sweepSettings: Output<ImageSweepSettingsArgs>? = null,
    public val targetColumnName: Output<String>? = null,
    public val taskType: Output<String>,
    public val trainingData: Output<MLTableJobInputArgs>,
    public val validationData: Output<MLTableJobInputArgs>? = null,
    public val validationDataSize: Output<Double>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.ImageObjectDetectionArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.ImageObjectDetectionArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.ImageObjectDetectionArgs.builder()
            .limitSettings(limitSettings.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .logVerbosity(
                logVerbosity?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .modelSettings(modelSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .primaryMetric(
                primaryMetric?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .searchSpace(
                searchSpace?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .sweepSettings(sweepSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .targetColumnName(targetColumnName?.applyValue({ args0 -> args0 }))
            .taskType(taskType.applyValue({ args0 -> args0 }))
            .trainingData(trainingData.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .validationData(validationData?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .validationDataSize(validationDataSize?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImageObjectDetectionArgs].
 */
@PulumiTagMarker
public class ImageObjectDetectionArgsBuilder internal constructor() {
    private var limitSettings: Output<ImageLimitSettingsArgs>? = null

    private var logVerbosity: Output<Either<String, LogVerbosity>>? = null

    private var modelSettings: Output<ImageModelSettingsObjectDetectionArgs>? = null

    private var primaryMetric: Output<Either<String, ObjectDetectionPrimaryMetrics>>? = null

    private var searchSpace: Output<List<ImageModelDistributionSettingsObjectDetectionArgs>>? = null

    private var sweepSettings: Output<ImageSweepSettingsArgs>? = null

    private var targetColumnName: Output<String>? = null

    private var taskType: Output<String>? = null

    private var trainingData: Output<MLTableJobInputArgs>? = null

    private var validationData: Output<MLTableJobInputArgs>? = null

    private var validationDataSize: Output<Double>? = null

    /**
     * @param value [Required] Limit settings for the AutoML job.
     */
    @JvmName("sejgqficlsfrjhsw")
    public suspend fun limitSettings(`value`: Output<ImageLimitSettingsArgs>) {
        this.limitSettings = value
    }

    /**
     * @param value Log verbosity for the job.
     */
    @JvmName("ddbrxlynouqeivpj")
    public suspend fun logVerbosity(`value`: Output<Either<String, LogVerbosity>>) {
        this.logVerbosity = value
    }

    /**
     * @param value Settings used for training the model.
     */
    @JvmName("idvdhfsroiupeigy")
    public suspend fun modelSettings(`value`: Output<ImageModelSettingsObjectDetectionArgs>) {
        this.modelSettings = value
    }

    /**
     * @param value Primary metric to optimize for this task.
     */
    @JvmName("flprewavcrvldtjc")
    public suspend fun primaryMetric(`value`: Output<Either<String, ObjectDetectionPrimaryMetrics>>) {
        this.primaryMetric = value
    }

    /**
     * @param value Search space for sampling different combinations of models and their hyperparameters.
     */
    @JvmName("sxulynjrenbtrfoi")
    public suspend fun searchSpace(`value`: Output<List<ImageModelDistributionSettingsObjectDetectionArgs>>) {
        this.searchSpace = value
    }

    @JvmName("gfjxkglbpcrnoeht")
    public suspend fun searchSpace(vararg values: Output<ImageModelDistributionSettingsObjectDetectionArgs>) {
        this.searchSpace = Output.all(values.asList())
    }

    /**
     * @param values Search space for sampling different combinations of models and their hyperparameters.
     */
    @JvmName("opdxcsnhpjocjmrn")
    public suspend fun searchSpace(values: List<Output<ImageModelDistributionSettingsObjectDetectionArgs>>) {
        this.searchSpace = Output.all(values)
    }

    /**
     * @param value Model sweeping and hyperparameter sweeping related settings.
     */
    @JvmName("bdmwmplweevlnwcb")
    public suspend fun sweepSettings(`value`: Output<ImageSweepSettingsArgs>) {
        this.sweepSettings = value
    }

    /**
     * @param value Target column name: This is prediction values column.
     * Also known as label column name in context of classification tasks.
     */
    @JvmName("bwbtcxugvflgqhgt")
    public suspend fun targetColumnName(`value`: Output<String>) {
        this.targetColumnName = value
    }

    /**
     * @param value AutoMLJob Task type.
     * Expected value is 'ImageObjectDetection'.
     */
    @JvmName("rsallkutqirxtqcf")
    public suspend fun taskType(`value`: Output<String>) {
        this.taskType = value
    }

    /**
     * @param value [Required] Training data input.
     */
    @JvmName("mutcjmsdjhclmfdm")
    public suspend fun trainingData(`value`: Output<MLTableJobInputArgs>) {
        this.trainingData = value
    }

    /**
     * @param value Validation data inputs.
     */
    @JvmName("bysouhmhfvspduia")
    public suspend fun validationData(`value`: Output<MLTableJobInputArgs>) {
        this.validationData = value
    }

    /**
     * @param value The fraction of training dataset that needs to be set aside for validation purpose.
     * Values between (0.0 , 1.0)
     * Applied when validation dataset is not provided.
     */
    @JvmName("tbckqkaydqtkqofq")
    public suspend fun validationDataSize(`value`: Output<Double>) {
        this.validationDataSize = value
    }

    /**
     * @param value [Required] Limit settings for the AutoML job.
     */
    @JvmName("oahhxxseltffnelk")
    public suspend fun limitSettings(`value`: ImageLimitSettingsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.limitSettings = mapped
    }

    /**
     * @param argument [Required] Limit settings for the AutoML job.
     */
    @JvmName("jslwgayluknukdku")
    public suspend fun limitSettings(argument: suspend ImageLimitSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = ImageLimitSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.limitSettings = mapped
    }

    /**
     * @param value Log verbosity for the job.
     */
    @JvmName("bwbqitrqsmyjmamd")
    public suspend fun logVerbosity(`value`: Either<String, LogVerbosity>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logVerbosity = mapped
    }

    /**
     * @param value Log verbosity for the job.
     */
    @JvmName("hhuauvgjjbqblroh")
    public fun logVerbosity(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LogVerbosity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logVerbosity = mapped
    }

    /**
     * @param value Log verbosity for the job.
     */
    @JvmName("cfoyixynqqgqmryu")
    public fun logVerbosity(`value`: LogVerbosity) {
        val toBeMapped = Either.ofRight<String, LogVerbosity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logVerbosity = mapped
    }

    /**
     * @param value Settings used for training the model.
     */
    @JvmName("uebjkwakoxmdehpl")
    public suspend fun modelSettings(`value`: ImageModelSettingsObjectDetectionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modelSettings = mapped
    }

    /**
     * @param argument Settings used for training the model.
     */
    @JvmName("wksoyqqtywfvtmov")
    public suspend fun modelSettings(argument: suspend ImageModelSettingsObjectDetectionArgsBuilder.() -> Unit) {
        val toBeMapped = ImageModelSettingsObjectDetectionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.modelSettings = mapped
    }

    /**
     * @param value Primary metric to optimize for this task.
     */
    @JvmName("qlidvnbbxfoeecdk")
    public suspend fun primaryMetric(`value`: Either<String, ObjectDetectionPrimaryMetrics>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryMetric = mapped
    }

    /**
     * @param value Primary metric to optimize for this task.
     */
    @JvmName("bylquvdpjanucfxl")
    public fun primaryMetric(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ObjectDetectionPrimaryMetrics>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.primaryMetric = mapped
    }

    /**
     * @param value Primary metric to optimize for this task.
     */
    @JvmName("qjglyyhfdovluidb")
    public fun primaryMetric(`value`: ObjectDetectionPrimaryMetrics) {
        val toBeMapped = Either.ofRight<String, ObjectDetectionPrimaryMetrics>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.primaryMetric = mapped
    }

    /**
     * @param value Search space for sampling different combinations of models and their hyperparameters.
     */
    @JvmName("eqgjouslugpqbecn")
    public suspend fun searchSpace(`value`: List<ImageModelDistributionSettingsObjectDetectionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.searchSpace = mapped
    }

    /**
     * @param argument Search space for sampling different combinations of models and their hyperparameters.
     */
    @JvmName("efdaqvkjpbaroofe")
    public suspend fun searchSpace(argument: List<suspend ImageModelDistributionSettingsObjectDetectionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ImageModelDistributionSettingsObjectDetectionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.searchSpace = mapped
    }

    /**
     * @param argument Search space for sampling different combinations of models and their hyperparameters.
     */
    @JvmName("juvlkvcjrtcgmfdy")
    public suspend fun searchSpace(vararg argument: suspend ImageModelDistributionSettingsObjectDetectionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ImageModelDistributionSettingsObjectDetectionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.searchSpace = mapped
    }

    /**
     * @param argument Search space for sampling different combinations of models and their hyperparameters.
     */
    @JvmName("gsyfpbmlhillfdpl")
    public suspend fun searchSpace(argument: suspend ImageModelDistributionSettingsObjectDetectionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ImageModelDistributionSettingsObjectDetectionArgsBuilder().applySuspend
                { argument() }.build(),
        )
        val mapped = of(toBeMapped)
        this.searchSpace = mapped
    }

    /**
     * @param values Search space for sampling different combinations of models and their hyperparameters.
     */
    @JvmName("foogcttgcsbllbeu")
    public suspend fun searchSpace(vararg values: ImageModelDistributionSettingsObjectDetectionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.searchSpace = mapped
    }

    /**
     * @param value Model sweeping and hyperparameter sweeping related settings.
     */
    @JvmName("gkggogyfhduymoyp")
    public suspend fun sweepSettings(`value`: ImageSweepSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sweepSettings = mapped
    }

    /**
     * @param argument Model sweeping and hyperparameter sweeping related settings.
     */
    @JvmName("vowlbeuaxwlfvfpw")
    public suspend fun sweepSettings(argument: suspend ImageSweepSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = ImageSweepSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sweepSettings = mapped
    }

    /**
     * @param value Target column name: This is prediction values column.
     * Also known as label column name in context of classification tasks.
     */
    @JvmName("wvyeyglwuuqtkbwo")
    public suspend fun targetColumnName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetColumnName = mapped
    }

    /**
     * @param value AutoMLJob Task type.
     * Expected value is 'ImageObjectDetection'.
     */
    @JvmName("wxdjupfjyrqmowvs")
    public suspend fun taskType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.taskType = mapped
    }

    /**
     * @param value [Required] Training data input.
     */
    @JvmName("cehxfqetdloykfpa")
    public suspend fun trainingData(`value`: MLTableJobInputArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trainingData = mapped
    }

    /**
     * @param argument [Required] Training data input.
     */
    @JvmName("uaxrloqhedbglrvb")
    public suspend fun trainingData(argument: suspend MLTableJobInputArgsBuilder.() -> Unit) {
        val toBeMapped = MLTableJobInputArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.trainingData = mapped
    }

    /**
     * @param value Validation data inputs.
     */
    @JvmName("ciwmubyiwrllxsgq")
    public suspend fun validationData(`value`: MLTableJobInputArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validationData = mapped
    }

    /**
     * @param argument Validation data inputs.
     */
    @JvmName("sysaiqgdpxxmwicf")
    public suspend fun validationData(argument: suspend MLTableJobInputArgsBuilder.() -> Unit) {
        val toBeMapped = MLTableJobInputArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.validationData = mapped
    }

    /**
     * @param value The fraction of training dataset that needs to be set aside for validation purpose.
     * Values between (0.0 , 1.0)
     * Applied when validation dataset is not provided.
     */
    @JvmName("pdyftgebyngcqonv")
    public suspend fun validationDataSize(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validationDataSize = mapped
    }

    internal fun build(): ImageObjectDetectionArgs = ImageObjectDetectionArgs(
        limitSettings = limitSettings ?: throw PulumiNullFieldException("limitSettings"),
        logVerbosity = logVerbosity,
        modelSettings = modelSettings,
        primaryMetric = primaryMetric,
        searchSpace = searchSpace,
        sweepSettings = sweepSettings,
        targetColumnName = targetColumnName,
        taskType = taskType ?: throw PulumiNullFieldException("taskType"),
        trainingData = trainingData ?: throw PulumiNullFieldException("trainingData"),
        validationData = validationData,
        validationDataSize = validationDataSize,
    )
}
