@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.InferenceGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Inference group configuration
 * @property bonusExtraCapacity Capacity to be used from the pool's reserved capacity.
 * optional
 * @property description Description of the resource.
 * @property metadata Metadata for the inference group.
 * @property priority Priority of the group within the N:Microsoft.MachineLearning.ManagementFrontEnd.Contracts.V20230801Preview.Pools.InferencePools.
 * @property properties Property dictionary. Properties can be added, but not removed or altered.
 */
public data class InferenceGroupArgs(
    public val bonusExtraCapacity: Output<Int>? = null,
    public val description: Output<String>? = null,
    public val metadata: Output<String>? = null,
    public val priority: Output<Int>? = null,
    public val properties: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.InferenceGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.InferenceGroupArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.InferenceGroupArgs.builder()
            .bonusExtraCapacity(bonusExtraCapacity?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .metadata(metadata?.applyValue({ args0 -> args0 }))
            .priority(priority?.applyValue({ args0 -> args0 }))
            .properties(
                properties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [InferenceGroupArgs].
 */
@PulumiTagMarker
public class InferenceGroupArgsBuilder internal constructor() {
    private var bonusExtraCapacity: Output<Int>? = null

    private var description: Output<String>? = null

    private var metadata: Output<String>? = null

    private var priority: Output<Int>? = null

    private var properties: Output<Map<String, String>>? = null

    /**
     * @param value Capacity to be used from the pool's reserved capacity.
     * optional
     */
    @JvmName("ogyhwhnxovhioemt")
    public suspend fun bonusExtraCapacity(`value`: Output<Int>) {
        this.bonusExtraCapacity = value
    }

    /**
     * @param value Description of the resource.
     */
    @JvmName("hvoegectkwgpsnug")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Metadata for the inference group.
     */
    @JvmName("mmvdhnwiggjlhedr")
    public suspend fun metadata(`value`: Output<String>) {
        this.metadata = value
    }

    /**
     * @param value Priority of the group within the N:Microsoft.MachineLearning.ManagementFrontEnd.Contracts.V20230801Preview.Pools.InferencePools.
     */
    @JvmName("mpofrdtjcekcbhuj")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value Property dictionary. Properties can be added, but not removed or altered.
     */
    @JvmName("hrxtsvqdilunswly")
    public suspend fun properties(`value`: Output<Map<String, String>>) {
        this.properties = value
    }

    /**
     * @param value Capacity to be used from the pool's reserved capacity.
     * optional
     */
    @JvmName("jlnpqeeqtijndjab")
    public suspend fun bonusExtraCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bonusExtraCapacity = mapped
    }

    /**
     * @param value Description of the resource.
     */
    @JvmName("kcmebbyfktjdvmyl")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Metadata for the inference group.
     */
    @JvmName("hjcbvsdccrgwgqms")
    public suspend fun metadata(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param value Priority of the group within the N:Microsoft.MachineLearning.ManagementFrontEnd.Contracts.V20230801Preview.Pools.InferencePools.
     */
    @JvmName("xulboaaxosjstgin")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value Property dictionary. Properties can be added, but not removed or altered.
     */
    @JvmName("nepxwjouyjgoycnl")
    public suspend fun properties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param values Property dictionary. Properties can be added, but not removed or altered.
     */
    @JvmName("sgrhdxwgwsnlmylj")
    public fun properties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    internal fun build(): InferenceGroupArgs = InferenceGroupArgs(
        bonusExtraCapacity = bonusExtraCapacity,
        description = description,
        metadata = metadata,
        priority = priority,
        properties = properties,
    )
}
