@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.LabelClassArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Label class definition
 * @property displayName Display name of the label class.
 * @property subclasses Dictionary of subclasses of the label class.
 */
public data class LabelClassArgs(
    public val displayName: Output<String>? = null,
    public val subclasses: Output<Map<String, LabelClassArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.LabelClassArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.LabelClassArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.LabelClassArgs.builder()
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .subclasses(
                subclasses?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [LabelClassArgs].
 */
@PulumiTagMarker
public class LabelClassArgsBuilder internal constructor() {
    private var displayName: Output<String>? = null

    private var subclasses: Output<Map<String, LabelClassArgs>>? = null

    /**
     * @param value Display name of the label class.
     */
    @JvmName("ygvixdgbutdlqwon")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Dictionary of subclasses of the label class.
     */
    @JvmName("eplyiysgblumwqbt")
    public suspend fun subclasses(`value`: Output<Map<String, LabelClassArgs>>) {
        this.subclasses = value
    }

    /**
     * @param value Display name of the label class.
     */
    @JvmName("ujiyuueptlsxbvxo")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Dictionary of subclasses of the label class.
     */
    @JvmName("ukchhquqtoskewie")
    public suspend fun subclasses(`value`: Map<String, LabelClassArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subclasses = mapped
    }

    /**
     * @param argument Dictionary of subclasses of the label class.
     */
    @JvmName("krdmjvfwhcffecjo")
    public suspend fun subclasses(vararg argument: Pair<String, suspend LabelClassArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                LabelClassArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.subclasses = mapped
    }

    /**
     * @param values Dictionary of subclasses of the label class.
     */
    @JvmName("sweqkgyjbyxrmqfn")
    public fun subclasses(vararg values: Pair<String, LabelClassArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subclasses = mapped
    }

    internal fun build(): LabelClassArgs = LabelClassArgs(
        displayName = displayName,
        subclasses = subclasses,
    )
}
