@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.LabelingDataConfigurationArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.IncrementalDataRefresh
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Labeling data configuration definition
 * @property dataId Resource Id of the data asset to perform labeling.
 * @property incrementalDataRefresh Indicates whether to enable incremental data refresh.
 */
public data class LabelingDataConfigurationArgs(
    public val dataId: Output<String>? = null,
    public val incrementalDataRefresh: Output<Either<String, IncrementalDataRefresh>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.LabelingDataConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.LabelingDataConfigurationArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.LabelingDataConfigurationArgs.builder()
            .dataId(dataId?.applyValue({ args0 -> args0 }))
            .incrementalDataRefresh(
                incrementalDataRefresh?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            ).build()
}

/**
 * Builder for [LabelingDataConfigurationArgs].
 */
@PulumiTagMarker
public class LabelingDataConfigurationArgsBuilder internal constructor() {
    private var dataId: Output<String>? = null

    private var incrementalDataRefresh: Output<Either<String, IncrementalDataRefresh>>? = null

    /**
     * @param value Resource Id of the data asset to perform labeling.
     */
    @JvmName("fhuglwlmvrhtamwb")
    public suspend fun dataId(`value`: Output<String>) {
        this.dataId = value
    }

    /**
     * @param value Indicates whether to enable incremental data refresh.
     */
    @JvmName("dtrkasrfgnlahfxt")
    public suspend fun incrementalDataRefresh(`value`: Output<Either<String, IncrementalDataRefresh>>) {
        this.incrementalDataRefresh = value
    }

    /**
     * @param value Resource Id of the data asset to perform labeling.
     */
    @JvmName("vvluhjrflvygwkaw")
    public suspend fun dataId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataId = mapped
    }

    /**
     * @param value Indicates whether to enable incremental data refresh.
     */
    @JvmName("fmljjbbvtpevnlbs")
    public suspend fun incrementalDataRefresh(`value`: Either<String, IncrementalDataRefresh>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.incrementalDataRefresh = mapped
    }

    /**
     * @param value Indicates whether to enable incremental data refresh.
     */
    @JvmName("wrkdddfxjejwpdjj")
    public fun incrementalDataRefresh(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IncrementalDataRefresh>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.incrementalDataRefresh = mapped
    }

    /**
     * @param value Indicates whether to enable incremental data refresh.
     */
    @JvmName("hwjqykbvjjnjmiei")
    public fun incrementalDataRefresh(`value`: IncrementalDataRefresh) {
        val toBeMapped = Either.ofRight<String, IncrementalDataRefresh>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.incrementalDataRefresh = mapped
    }

    internal fun build(): LabelingDataConfigurationArgs = LabelingDataConfigurationArgs(
        dataId = dataId,
        incrementalDataRefresh = incrementalDataRefresh,
    )
}
