@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.MaterializationSettingsArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.MaterializationStoreType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property notification Specifies the notification details
 * @property resource Specifies the compute resource settings
 * @property schedule Specifies the schedule details
 * @property sparkConfiguration Specifies the spark compute settings
 * @property storeType Specifies the stores to which materialization should happen
 */
public data class MaterializationSettingsArgs(
    public val notification: Output<NotificationSettingArgs>? = null,
    public val resource: Output<MaterializationComputeResourceArgs>? = null,
    public val schedule: Output<RecurrenceTriggerArgs>? = null,
    public val sparkConfiguration: Output<Map<String, String>>? = null,
    public val storeType: Output<Either<String, MaterializationStoreType>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.MaterializationSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.MaterializationSettingsArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.MaterializationSettingsArgs.builder()
            .notification(notification?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resource(resource?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .schedule(schedule?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sparkConfiguration(
                sparkConfiguration?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .storeType(
                storeType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [MaterializationSettingsArgs].
 */
@PulumiTagMarker
public class MaterializationSettingsArgsBuilder internal constructor() {
    private var notification: Output<NotificationSettingArgs>? = null

    private var resource: Output<MaterializationComputeResourceArgs>? = null

    private var schedule: Output<RecurrenceTriggerArgs>? = null

    private var sparkConfiguration: Output<Map<String, String>>? = null

    private var storeType: Output<Either<String, MaterializationStoreType>>? = null

    /**
     * @param value Specifies the notification details
     */
    @JvmName("gigqiuyhyuvtwrok")
    public suspend fun notification(`value`: Output<NotificationSettingArgs>) {
        this.notification = value
    }

    /**
     * @param value Specifies the compute resource settings
     */
    @JvmName("duhoyqhdpmhvglvv")
    public suspend fun resource(`value`: Output<MaterializationComputeResourceArgs>) {
        this.resource = value
    }

    /**
     * @param value Specifies the schedule details
     */
    @JvmName("ejkgcvtwslraeafp")
    public suspend fun schedule(`value`: Output<RecurrenceTriggerArgs>) {
        this.schedule = value
    }

    /**
     * @param value Specifies the spark compute settings
     */
    @JvmName("ytavcayyuhqauktm")
    public suspend fun sparkConfiguration(`value`: Output<Map<String, String>>) {
        this.sparkConfiguration = value
    }

    /**
     * @param value Specifies the stores to which materialization should happen
     */
    @JvmName("lepswecrwfnnjolp")
    public suspend fun storeType(`value`: Output<Either<String, MaterializationStoreType>>) {
        this.storeType = value
    }

    /**
     * @param value Specifies the notification details
     */
    @JvmName("ariyhxotecstksjr")
    public suspend fun notification(`value`: NotificationSettingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notification = mapped
    }

    /**
     * @param argument Specifies the notification details
     */
    @JvmName("nxrkkkmnbatxmdwj")
    public suspend fun notification(argument: suspend NotificationSettingArgsBuilder.() -> Unit) {
        val toBeMapped = NotificationSettingArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.notification = mapped
    }

    /**
     * @param value Specifies the compute resource settings
     */
    @JvmName("oktroqditkkpcwnl")
    public suspend fun resource(`value`: MaterializationComputeResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resource = mapped
    }

    /**
     * @param argument Specifies the compute resource settings
     */
    @JvmName("ulfysuopasjsepsw")
    public suspend fun resource(argument: suspend MaterializationComputeResourceArgsBuilder.() -> Unit) {
        val toBeMapped = MaterializationComputeResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.resource = mapped
    }

    /**
     * @param value Specifies the schedule details
     */
    @JvmName("xgapctevbmekoskj")
    public suspend fun schedule(`value`: RecurrenceTriggerArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schedule = mapped
    }

    /**
     * @param argument Specifies the schedule details
     */
    @JvmName("qjyuaxohxktbwnyp")
    public suspend fun schedule(argument: suspend RecurrenceTriggerArgsBuilder.() -> Unit) {
        val toBeMapped = RecurrenceTriggerArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.schedule = mapped
    }

    /**
     * @param value Specifies the spark compute settings
     */
    @JvmName("sxlagfmxpujtdswt")
    public suspend fun sparkConfiguration(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sparkConfiguration = mapped
    }

    /**
     * @param values Specifies the spark compute settings
     */
    @JvmName("cvdvgmaryxjfbcjk")
    public fun sparkConfiguration(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sparkConfiguration = mapped
    }

    /**
     * @param value Specifies the stores to which materialization should happen
     */
    @JvmName("jwwtefxrvepvvgly")
    public suspend fun storeType(`value`: Either<String, MaterializationStoreType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storeType = mapped
    }

    /**
     * @param value Specifies the stores to which materialization should happen
     */
    @JvmName("fexxwkkxohobldua")
    public fun storeType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, MaterializationStoreType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storeType = mapped
    }

    /**
     * @param value Specifies the stores to which materialization should happen
     */
    @JvmName("eeeiyfqqgtxrsbcn")
    public fun storeType(`value`: MaterializationStoreType) {
        val toBeMapped = Either.ofRight<String, MaterializationStoreType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storeType = mapped
    }

    internal fun build(): MaterializationSettingsArgs = MaterializationSettingsArgs(
        notification = notification,
        resource = resource,
        schedule = schedule,
        sparkConfiguration = sparkConfiguration,
        storeType = storeType,
    )
}
