@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.PipelineJobArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Pipeline Job definition: defines generic to MFE attributes.
 * @property componentId ARM resource ID of the component resource.
 * @property computeId ARM resource ID of the compute resource.
 * @property description The asset description text.
 * @property displayName Display name of job.
 * @property experimentName The name of the experiment the job belongs to. If not set, the job is placed in the "Default" experiment.
 * @property identity Identity configuration. If set, this should be one of AmlToken, ManagedIdentity, UserIdentity or null.
 * Defaults to AmlToken if null.
 * @property inputs Inputs for the pipeline job.
 * @property isArchived Is the asset archived?
 * @property jobType Enum to determine the type of job.
 * Expected value is 'Pipeline'.
 * @property jobs Jobs construct the Pipeline Job.
 * @property outputs Outputs for the pipeline job
 * @property properties The asset property dictionary.
 * @property services List of JobEndpoints.
 * For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
 * @property settings Pipeline settings, for things like ContinueRunOnStepFailure etc.
 * @property sourceJobId ARM resource ID of source job.
 * @property tags Tag dictionary. Tags can be added, removed, and updated.
 */
public data class PipelineJobArgs(
    public val componentId: Output<String>? = null,
    public val computeId: Output<String>? = null,
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val experimentName: Output<String>? = null,
    public val identity: Output<Any>? = null,
    public val inputs: Output<Map<String, Any>>? = null,
    public val isArchived: Output<Boolean>? = null,
    public val jobType: Output<String>,
    public val jobs: Output<Map<String, Any>>? = null,
    public val outputs: Output<Map<String, Any>>? = null,
    public val properties: Output<Map<String, String>>? = null,
    public val services: Output<Map<String, JobServiceArgs>>? = null,
    public val settings: Output<Any>? = null,
    public val sourceJobId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.PipelineJobArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.PipelineJobArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.PipelineJobArgs.builder()
            .componentId(componentId?.applyValue({ args0 -> args0 }))
            .computeId(computeId?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .experimentName(experimentName?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0 }))
            .inputs(inputs?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .isArchived(isArchived?.applyValue({ args0 -> args0 }))
            .jobType(jobType.applyValue({ args0 -> args0 }))
            .jobs(jobs?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .outputs(outputs?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .properties(
                properties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .services(
                services?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .settings(settings?.applyValue({ args0 -> args0 }))
            .sourceJobId(sourceJobId?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [PipelineJobArgs].
 */
@PulumiTagMarker
public class PipelineJobArgsBuilder internal constructor() {
    private var componentId: Output<String>? = null

    private var computeId: Output<String>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var experimentName: Output<String>? = null

    private var identity: Output<Any>? = null

    private var inputs: Output<Map<String, Any>>? = null

    private var isArchived: Output<Boolean>? = null

    private var jobType: Output<String>? = null

    private var jobs: Output<Map<String, Any>>? = null

    private var outputs: Output<Map<String, Any>>? = null

    private var properties: Output<Map<String, String>>? = null

    private var services: Output<Map<String, JobServiceArgs>>? = null

    private var settings: Output<Any>? = null

    private var sourceJobId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value ARM resource ID of the component resource.
     */
    @JvmName("haavmueutmcuddyn")
    public suspend fun componentId(`value`: Output<String>) {
        this.componentId = value
    }

    /**
     * @param value ARM resource ID of the compute resource.
     */
    @JvmName("itixulmfkrxaajce")
    public suspend fun computeId(`value`: Output<String>) {
        this.computeId = value
    }

    /**
     * @param value The asset description text.
     */
    @JvmName("cnykmktlvqumioge")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Display name of job.
     */
    @JvmName("aecwvphhbvbltusq")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The name of the experiment the job belongs to. If not set, the job is placed in the "Default" experiment.
     */
    @JvmName("bodrjteytnhdynam")
    public suspend fun experimentName(`value`: Output<String>) {
        this.experimentName = value
    }

    /**
     * @param value Identity configuration. If set, this should be one of AmlToken, ManagedIdentity, UserIdentity or null.
     * Defaults to AmlToken if null.
     */
    @JvmName("lvlgvyukfirrdion")
    public suspend fun identity(`value`: Output<Any>) {
        this.identity = value
    }

    /**
     * @param value Inputs for the pipeline job.
     */
    @JvmName("dfwcjwxcgudcwtat")
    public suspend fun inputs(`value`: Output<Map<String, Any>>) {
        this.inputs = value
    }

    /**
     * @param value Is the asset archived?
     */
    @JvmName("itrnpsrohrgsdxtl")
    public suspend fun isArchived(`value`: Output<Boolean>) {
        this.isArchived = value
    }

    /**
     * @param value Enum to determine the type of job.
     * Expected value is 'Pipeline'.
     */
    @JvmName("lyidqmiywoxbghpk")
    public suspend fun jobType(`value`: Output<String>) {
        this.jobType = value
    }

    /**
     * @param value Jobs construct the Pipeline Job.
     */
    @JvmName("xowefqwrxwnvobam")
    public suspend fun jobs(`value`: Output<Map<String, Any>>) {
        this.jobs = value
    }

    /**
     * @param value Outputs for the pipeline job
     */
    @JvmName("yiawjuxyxfwprxut")
    public suspend fun outputs(`value`: Output<Map<String, Any>>) {
        this.outputs = value
    }

    /**
     * @param value The asset property dictionary.
     */
    @JvmName("ywfajkhjnmlpbfjm")
    public suspend fun properties(`value`: Output<Map<String, String>>) {
        this.properties = value
    }

    /**
     * @param value List of JobEndpoints.
     * For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
     */
    @JvmName("qbddtjnkaornbric")
    public suspend fun services(`value`: Output<Map<String, JobServiceArgs>>) {
        this.services = value
    }

    /**
     * @param value Pipeline settings, for things like ContinueRunOnStepFailure etc.
     */
    @JvmName("bmshehntxcscbtvu")
    public suspend fun settings(`value`: Output<Any>) {
        this.settings = value
    }

    /**
     * @param value ARM resource ID of source job.
     */
    @JvmName("ucrlupnsulytrkur")
    public suspend fun sourceJobId(`value`: Output<String>) {
        this.sourceJobId = value
    }

    /**
     * @param value Tag dictionary. Tags can be added, removed, and updated.
     */
    @JvmName("rqhmlcltxpspmveh")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value ARM resource ID of the component resource.
     */
    @JvmName("qyyqxsofagfevstu")
    public suspend fun componentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.componentId = mapped
    }

    /**
     * @param value ARM resource ID of the compute resource.
     */
    @JvmName("ncumkggkjsxnbjol")
    public suspend fun computeId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computeId = mapped
    }

    /**
     * @param value The asset description text.
     */
    @JvmName("uupuugnnwixrfbol")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Display name of job.
     */
    @JvmName("ewqahmjgfnokseex")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The name of the experiment the job belongs to. If not set, the job is placed in the "Default" experiment.
     */
    @JvmName("fglcsjyyxkjhhbjc")
    public suspend fun experimentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.experimentName = mapped
    }

    /**
     * @param value Identity configuration. If set, this should be one of AmlToken, ManagedIdentity, UserIdentity or null.
     * Defaults to AmlToken if null.
     */
    @JvmName("gmiwxthnskkjkyfs")
    public suspend fun identity(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param value Inputs for the pipeline job.
     */
    @JvmName("brsukvunxiaguvuy")
    public suspend fun inputs(`value`: Map<String, Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputs = mapped
    }

    /**
     * @param values Inputs for the pipeline job.
     */
    @JvmName("jeadyuivnipgkpup")
    public fun inputs(vararg values: Pair<String, Any>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inputs = mapped
    }

    /**
     * @param value Is the asset archived?
     */
    @JvmName("xftmqhumwtbvlpvw")
    public suspend fun isArchived(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isArchived = mapped
    }

    /**
     * @param value Enum to determine the type of job.
     * Expected value is 'Pipeline'.
     */
    @JvmName("sdukmapicrqpmjip")
    public suspend fun jobType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.jobType = mapped
    }

    /**
     * @param value Jobs construct the Pipeline Job.
     */
    @JvmName("vmnjtoyqhrilulqi")
    public suspend fun jobs(`value`: Map<String, Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jobs = mapped
    }

    /**
     * @param values Jobs construct the Pipeline Job.
     */
    @JvmName("cqyldpbbycaetirn")
    public fun jobs(vararg values: Pair<String, Any>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.jobs = mapped
    }

    /**
     * @param value Outputs for the pipeline job
     */
    @JvmName("qenadhyugjesfytr")
    public suspend fun outputs(`value`: Map<String, Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outputs = mapped
    }

    /**
     * @param values Outputs for the pipeline job
     */
    @JvmName("kddeichkgddotwkd")
    public fun outputs(vararg values: Pair<String, Any>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.outputs = mapped
    }

    /**
     * @param value The asset property dictionary.
     */
    @JvmName("fjwpsighdhobkfax")
    public suspend fun properties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param values The asset property dictionary.
     */
    @JvmName("scyupafxjnyoiwnr")
    public fun properties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value List of JobEndpoints.
     * For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
     */
    @JvmName("stmovpwtusrepqkv")
    public suspend fun services(`value`: Map<String, JobServiceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.services = mapped
    }

    /**
     * @param argument List of JobEndpoints.
     * For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
     */
    @JvmName("ccsuygkofbxtsscn")
    public suspend fun services(vararg argument: Pair<String, suspend JobServiceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                JobServiceArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.services = mapped
    }

    /**
     * @param values List of JobEndpoints.
     * For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
     */
    @JvmName("jyxhqobqexqmspro")
    public fun services(vararg values: Pair<String, JobServiceArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.services = mapped
    }

    /**
     * @param value Pipeline settings, for things like ContinueRunOnStepFailure etc.
     */
    @JvmName("cgcmordrrjpwfxtp")
    public suspend fun settings(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.settings = mapped
    }

    /**
     * @param value ARM resource ID of source job.
     */
    @JvmName("uefpevsmmrcbolkh")
    public suspend fun sourceJobId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceJobId = mapped
    }

    /**
     * @param value Tag dictionary. Tags can be added, removed, and updated.
     */
    @JvmName("yddijrnqpaygltxd")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tag dictionary. Tags can be added, removed, and updated.
     */
    @JvmName("dkpetchamicwoygo")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): PipelineJobArgs = PipelineJobArgs(
        componentId = componentId,
        computeId = computeId,
        description = description,
        displayName = displayName,
        experimentName = experimentName,
        identity = identity,
        inputs = inputs,
        isArchived = isArchived,
        jobType = jobType ?: throw PulumiNullFieldException("jobType"),
        jobs = jobs,
        outputs = outputs,
        properties = properties,
        services = services,
        settings = settings,
        sourceJobId = sourceJobId,
        tags = tags,
    )
}
