@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.PrivateEndpointDestinationArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.RuleStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Private Endpoint destination for a Private Endpoint Outbound Rule for the managed network of a machine learning workspace.
 * @property serviceResourceId
 * @property sparkEnabled
 * @property sparkStatus Status of a managed network Outbound Rule of a machine learning workspace.
 * @property subresourceTarget
 */
public data class PrivateEndpointDestinationArgs(
    public val serviceResourceId: Output<String>? = null,
    public val sparkEnabled: Output<Boolean>? = null,
    public val sparkStatus: Output<Either<String, RuleStatus>>? = null,
    public val subresourceTarget: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.PrivateEndpointDestinationArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.PrivateEndpointDestinationArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.PrivateEndpointDestinationArgs.builder()
            .serviceResourceId(serviceResourceId?.applyValue({ args0 -> args0 }))
            .sparkEnabled(sparkEnabled?.applyValue({ args0 -> args0 }))
            .sparkStatus(
                sparkStatus?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .subresourceTarget(subresourceTarget?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateEndpointDestinationArgs].
 */
@PulumiTagMarker
public class PrivateEndpointDestinationArgsBuilder internal constructor() {
    private var serviceResourceId: Output<String>? = null

    private var sparkEnabled: Output<Boolean>? = null

    private var sparkStatus: Output<Either<String, RuleStatus>>? = null

    private var subresourceTarget: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("jsnmvpftivkvwgjx")
    public suspend fun serviceResourceId(`value`: Output<String>) {
        this.serviceResourceId = value
    }

    /**
     * @param value
     */
    @JvmName("wuhaabdmbhptvpkk")
    public suspend fun sparkEnabled(`value`: Output<Boolean>) {
        this.sparkEnabled = value
    }

    /**
     * @param value Status of a managed network Outbound Rule of a machine learning workspace.
     */
    @JvmName("cuftcvprxpjqciwo")
    public suspend fun sparkStatus(`value`: Output<Either<String, RuleStatus>>) {
        this.sparkStatus = value
    }

    /**
     * @param value
     */
    @JvmName("cxgxjuojmbvkmitt")
    public suspend fun subresourceTarget(`value`: Output<String>) {
        this.subresourceTarget = value
    }

    /**
     * @param value
     */
    @JvmName("wlbydwhvangseyfo")
    public suspend fun serviceResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceResourceId = mapped
    }

    /**
     * @param value
     */
    @JvmName("amvvjhumicascgow")
    public suspend fun sparkEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sparkEnabled = mapped
    }

    /**
     * @param value Status of a managed network Outbound Rule of a machine learning workspace.
     */
    @JvmName("cpfnajopfcheghqc")
    public suspend fun sparkStatus(`value`: Either<String, RuleStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sparkStatus = mapped
    }

    /**
     * @param value Status of a managed network Outbound Rule of a machine learning workspace.
     */
    @JvmName("onlygxiooxfqifoa")
    public fun sparkStatus(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RuleStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sparkStatus = mapped
    }

    /**
     * @param value Status of a managed network Outbound Rule of a machine learning workspace.
     */
    @JvmName("ckdifltkkvvxnmhr")
    public fun sparkStatus(`value`: RuleStatus) {
        val toBeMapped = Either.ofRight<String, RuleStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sparkStatus = mapped
    }

    /**
     * @param value
     */
    @JvmName("ggjmdavgqhyqvofa")
    public suspend fun subresourceTarget(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subresourceTarget = mapped
    }

    internal fun build(): PrivateEndpointDestinationArgs = PrivateEndpointDestinationArgs(
        serviceResourceId = serviceResourceId,
        sparkEnabled = sparkEnabled,
        sparkStatus = sparkStatus,
        subresourceTarget = subresourceTarget,
    )
}
