@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.PrivateEndpointOutboundRuleArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.RuleCategory
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.RuleStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Private Endpoint Outbound Rule for the managed network of a machine learning workspace.
 * @property category Category of a managed network Outbound Rule of a machine learning workspace.
 * @property destination Private Endpoint destination for a Private Endpoint Outbound Rule for the managed network of a machine learning workspace.
 * @property status Status of a managed network Outbound Rule of a machine learning workspace.
 * @property type Type of a managed network Outbound Rule of a machine learning workspace.
 * Expected value is 'PrivateEndpoint'.
 */
public data class PrivateEndpointOutboundRuleArgs(
    public val category: Output<Either<String, RuleCategory>>? = null,
    public val destination: Output<PrivateEndpointDestinationArgs>? = null,
    public val status: Output<Either<String, RuleStatus>>? = null,
    public val type: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.PrivateEndpointOutboundRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.PrivateEndpointOutboundRuleArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.PrivateEndpointOutboundRuleArgs.builder()
            .category(
                category?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .destination(destination?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .status(
                status?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateEndpointOutboundRuleArgs].
 */
@PulumiTagMarker
public class PrivateEndpointOutboundRuleArgsBuilder internal constructor() {
    private var category: Output<Either<String, RuleCategory>>? = null

    private var destination: Output<PrivateEndpointDestinationArgs>? = null

    private var status: Output<Either<String, RuleStatus>>? = null

    private var type: Output<String>? = null

    /**
     * @param value Category of a managed network Outbound Rule of a machine learning workspace.
     */
    @JvmName("jahwfviktrytogfa")
    public suspend fun category(`value`: Output<Either<String, RuleCategory>>) {
        this.category = value
    }

    /**
     * @param value Private Endpoint destination for a Private Endpoint Outbound Rule for the managed network of a machine learning workspace.
     */
    @JvmName("wgihuamggxoayebj")
    public suspend fun destination(`value`: Output<PrivateEndpointDestinationArgs>) {
        this.destination = value
    }

    /**
     * @param value Status of a managed network Outbound Rule of a machine learning workspace.
     */
    @JvmName("oigfodiggaluccge")
    public suspend fun status(`value`: Output<Either<String, RuleStatus>>) {
        this.status = value
    }

    /**
     * @param value Type of a managed network Outbound Rule of a machine learning workspace.
     * Expected value is 'PrivateEndpoint'.
     */
    @JvmName("nnxhkmkffsoscguv")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Category of a managed network Outbound Rule of a machine learning workspace.
     */
    @JvmName("mdgfjumbnhwptdff")
    public suspend fun category(`value`: Either<String, RuleCategory>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value Category of a managed network Outbound Rule of a machine learning workspace.
     */
    @JvmName("axnqrshwddrjacjv")
    public fun category(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RuleCategory>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value Category of a managed network Outbound Rule of a machine learning workspace.
     */
    @JvmName("shudfewkgfrnuejj")
    public fun category(`value`: RuleCategory) {
        val toBeMapped = Either.ofRight<String, RuleCategory>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value Private Endpoint destination for a Private Endpoint Outbound Rule for the managed network of a machine learning workspace.
     */
    @JvmName("oetisbtbmufbvvsu")
    public suspend fun destination(`value`: PrivateEndpointDestinationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destination = mapped
    }

    /**
     * @param argument Private Endpoint destination for a Private Endpoint Outbound Rule for the managed network of a machine learning workspace.
     */
    @JvmName("igchfprvtmoqfqfx")
    public suspend fun destination(argument: suspend PrivateEndpointDestinationArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateEndpointDestinationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.destination = mapped
    }

    /**
     * @param value Status of a managed network Outbound Rule of a machine learning workspace.
     */
    @JvmName("cpyaeuettkklvenq")
    public suspend fun status(`value`: Either<String, RuleStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Status of a managed network Outbound Rule of a machine learning workspace.
     */
    @JvmName("jvsmjfldlxowkktl")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RuleStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Status of a managed network Outbound Rule of a machine learning workspace.
     */
    @JvmName("jyqlthpfehcittte")
    public fun status(`value`: RuleStatus) {
        val toBeMapped = Either.ofRight<String, RuleStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Type of a managed network Outbound Rule of a machine learning workspace.
     * Expected value is 'PrivateEndpoint'.
     */
    @JvmName("wwkyxpumgwkgnatt")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): PrivateEndpointOutboundRuleArgs = PrivateEndpointOutboundRuleArgs(
        category = category,
        destination = destination,
        status = status,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
