@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.RaiPolicyPropertiesArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.RaiPolicyMode
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.RaiPolicyType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Azure OpenAI Content Filters properties.
 * @property basePolicyName Name of the base Content Filters.
 * @property completionBlocklists
 * @property contentFilters
 * @property mode Content Filters mode.
 * @property promptBlocklists
 * @property type Content Filters policy type.
 */
public data class RaiPolicyPropertiesArgs(
    public val basePolicyName: Output<String>? = null,
    public val completionBlocklists: Output<List<RaiBlocklistConfigArgs>>? = null,
    public val contentFilters: Output<List<RaiPolicyContentFilterArgs>>? = null,
    public val mode: Output<Either<String, RaiPolicyMode>>? = null,
    public val promptBlocklists: Output<List<RaiBlocklistConfigArgs>>? = null,
    public val type: Output<Either<String, RaiPolicyType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.RaiPolicyPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.RaiPolicyPropertiesArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.RaiPolicyPropertiesArgs.builder()
            .basePolicyName(basePolicyName?.applyValue({ args0 -> args0 }))
            .completionBlocklists(
                completionBlocklists?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .contentFilters(
                contentFilters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .mode(
                mode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .promptBlocklists(
                promptBlocklists?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [RaiPolicyPropertiesArgs].
 */
@PulumiTagMarker
public class RaiPolicyPropertiesArgsBuilder internal constructor() {
    private var basePolicyName: Output<String>? = null

    private var completionBlocklists: Output<List<RaiBlocklistConfigArgs>>? = null

    private var contentFilters: Output<List<RaiPolicyContentFilterArgs>>? = null

    private var mode: Output<Either<String, RaiPolicyMode>>? = null

    private var promptBlocklists: Output<List<RaiBlocklistConfigArgs>>? = null

    private var type: Output<Either<String, RaiPolicyType>>? = null

    /**
     * @param value Name of the base Content Filters.
     */
    @JvmName("dkuncsxdhjgwohwq")
    public suspend fun basePolicyName(`value`: Output<String>) {
        this.basePolicyName = value
    }

    /**
     * @param value
     */
    @JvmName("dawdgthtfrcrnveh")
    public suspend fun completionBlocklists(`value`: Output<List<RaiBlocklistConfigArgs>>) {
        this.completionBlocklists = value
    }

    @JvmName("pshbhmedpivxsnnu")
    public suspend fun completionBlocklists(vararg values: Output<RaiBlocklistConfigArgs>) {
        this.completionBlocklists = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("iccyxwdgxcnxxcqu")
    public suspend fun completionBlocklists(values: List<Output<RaiBlocklistConfigArgs>>) {
        this.completionBlocklists = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("bsyhfqibgbatiapu")
    public suspend fun contentFilters(`value`: Output<List<RaiPolicyContentFilterArgs>>) {
        this.contentFilters = value
    }

    @JvmName("gbrrgjcgtjgwvyss")
    public suspend fun contentFilters(vararg values: Output<RaiPolicyContentFilterArgs>) {
        this.contentFilters = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("edrdylcyuqyxhwup")
    public suspend fun contentFilters(values: List<Output<RaiPolicyContentFilterArgs>>) {
        this.contentFilters = Output.all(values)
    }

    /**
     * @param value Content Filters mode.
     */
    @JvmName("ynalcyaibeulvcrx")
    public suspend fun mode(`value`: Output<Either<String, RaiPolicyMode>>) {
        this.mode = value
    }

    /**
     * @param value
     */
    @JvmName("lhwbktjlrfqxpyaw")
    public suspend fun promptBlocklists(`value`: Output<List<RaiBlocklistConfigArgs>>) {
        this.promptBlocklists = value
    }

    @JvmName("cyqswbjgesjavoln")
    public suspend fun promptBlocklists(vararg values: Output<RaiBlocklistConfigArgs>) {
        this.promptBlocklists = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("iagghbbsmojsomwy")
    public suspend fun promptBlocklists(values: List<Output<RaiBlocklistConfigArgs>>) {
        this.promptBlocklists = Output.all(values)
    }

    /**
     * @param value Content Filters policy type.
     */
    @JvmName("pllfmeyuhygjafhv")
    public suspend fun type(`value`: Output<Either<String, RaiPolicyType>>) {
        this.type = value
    }

    /**
     * @param value Name of the base Content Filters.
     */
    @JvmName("eaaaxctejkuscuby")
    public suspend fun basePolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.basePolicyName = mapped
    }

    /**
     * @param value
     */
    @JvmName("espgxrfktspmiifr")
    public suspend fun completionBlocklists(`value`: List<RaiBlocklistConfigArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.completionBlocklists = mapped
    }

    /**
     * @param argument
     */
    @JvmName("igddjvkndshlqlnx")
    public suspend fun completionBlocklists(argument: List<suspend RaiBlocklistConfigArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RaiBlocklistConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.completionBlocklists = mapped
    }

    /**
     * @param argument
     */
    @JvmName("bayhwuesoljkhavl")
    public suspend fun completionBlocklists(vararg argument: suspend RaiBlocklistConfigArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RaiBlocklistConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.completionBlocklists = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ywfxbbxfddambjdf")
    public suspend fun completionBlocklists(argument: suspend RaiBlocklistConfigArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RaiBlocklistConfigArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.completionBlocklists = mapped
    }

    /**
     * @param values
     */
    @JvmName("mntseaenyvyiykbj")
    public suspend fun completionBlocklists(vararg values: RaiBlocklistConfigArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.completionBlocklists = mapped
    }

    /**
     * @param value
     */
    @JvmName("phabdpoxyeofrbsp")
    public suspend fun contentFilters(`value`: List<RaiPolicyContentFilterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentFilters = mapped
    }

    /**
     * @param argument
     */
    @JvmName("gcapnlrwamnotuec")
    public suspend fun contentFilters(argument: List<suspend RaiPolicyContentFilterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RaiPolicyContentFilterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.contentFilters = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ibpijvhbhkgssaku")
    public suspend fun contentFilters(vararg argument: suspend RaiPolicyContentFilterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RaiPolicyContentFilterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.contentFilters = mapped
    }

    /**
     * @param argument
     */
    @JvmName("brwrnqccoqdsfjyo")
    public suspend fun contentFilters(argument: suspend RaiPolicyContentFilterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RaiPolicyContentFilterArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.contentFilters = mapped
    }

    /**
     * @param values
     */
    @JvmName("cglvdyrdnxhqtaqh")
    public suspend fun contentFilters(vararg values: RaiPolicyContentFilterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contentFilters = mapped
    }

    /**
     * @param value Content Filters mode.
     */
    @JvmName("oqcidixrybepmfbt")
    public suspend fun mode(`value`: Either<String, RaiPolicyMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value Content Filters mode.
     */
    @JvmName("xtlaypbeyjlifits")
    public fun mode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RaiPolicyMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value Content Filters mode.
     */
    @JvmName("fmsdtfafjurblqam")
    public fun mode(`value`: RaiPolicyMode) {
        val toBeMapped = Either.ofRight<String, RaiPolicyMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value
     */
    @JvmName("xjsarmgqdxljfelf")
    public suspend fun promptBlocklists(`value`: List<RaiBlocklistConfigArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.promptBlocklists = mapped
    }

    /**
     * @param argument
     */
    @JvmName("dynlttuxpykevdfi")
    public suspend fun promptBlocklists(argument: List<suspend RaiBlocklistConfigArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RaiBlocklistConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.promptBlocklists = mapped
    }

    /**
     * @param argument
     */
    @JvmName("bqnevyiqxpremepy")
    public suspend fun promptBlocklists(vararg argument: suspend RaiBlocklistConfigArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RaiBlocklistConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.promptBlocklists = mapped
    }

    /**
     * @param argument
     */
    @JvmName("emqfdmvgsgvwcsgc")
    public suspend fun promptBlocklists(argument: suspend RaiBlocklistConfigArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RaiBlocklistConfigArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.promptBlocklists = mapped
    }

    /**
     * @param values
     */
    @JvmName("ewssvcwxajdbwjwd")
    public suspend fun promptBlocklists(vararg values: RaiBlocklistConfigArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.promptBlocklists = mapped
    }

    /**
     * @param value Content Filters policy type.
     */
    @JvmName("wodrubtnupymoruv")
    public suspend fun type(`value`: Either<String, RaiPolicyType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Content Filters policy type.
     */
    @JvmName("jlkxouecouesytxy")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RaiPolicyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Content Filters policy type.
     */
    @JvmName("kmvvnfkfhkblhppo")
    public fun type(`value`: RaiPolicyType) {
        val toBeMapped = Either.ofRight<String, RaiPolicyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): RaiPolicyPropertiesArgs = RaiPolicyPropertiesArgs(
        basePolicyName = basePolicyName,
        completionBlocklists = completionBlocklists,
        contentFilters = contentFilters,
        mode = mode,
        promptBlocklists = promptBlocklists,
        type = type,
    )
}
