@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.RecurrenceTriggerArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.RecurrenceFrequency
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property endTime Specifies end time of schedule in ISO 8601, but without a UTC offset. Refer https://en.wikipedia.org/wiki/ISO_8601.
 * Recommented format would be "2022-06-01T00:00:01"
 * If not present, the schedule will run indefinitely
 * @property frequency [Required] The frequency to trigger schedule.
 * @property interval [Required] Specifies schedule interval in conjunction with frequency
 * @property schedule The recurrence schedule.
 * @property startTime Specifies start time of schedule in ISO 8601 format, but without a UTC offset.
 * @property timeZone Specifies time zone in which the schedule runs.
 * TimeZone should follow Windows time zone format. Refer: https://docs.microsoft.com/en-us/windows-hardware/manufacture/desktop/default-time-zones?view=windows-11
 * @property triggerType
 * Expected value is 'Recurrence'.
 */
public data class RecurrenceTriggerArgs(
    public val endTime: Output<String>? = null,
    public val frequency: Output<Either<String, RecurrenceFrequency>>,
    public val interval: Output<Int>,
    public val schedule: Output<RecurrenceScheduleArgs>? = null,
    public val startTime: Output<String>? = null,
    public val timeZone: Output<String>? = null,
    public val triggerType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.RecurrenceTriggerArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.RecurrenceTriggerArgs = com.pulumi.azurenative.machinelearningservices.inputs.RecurrenceTriggerArgs.builder()
        .endTime(endTime?.applyValue({ args0 -> args0 }))
        .frequency(
            frequency.applyValue({ args0 ->
                args0.transform({ args0 -> args0 }, { args0 ->
                    args0.let({ args0 -> args0.toJava() })
                })
            }),
        )
        .interval(interval.applyValue({ args0 -> args0 }))
        .schedule(schedule?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .startTime(startTime?.applyValue({ args0 -> args0 }))
        .timeZone(timeZone?.applyValue({ args0 -> args0 }))
        .triggerType(triggerType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RecurrenceTriggerArgs].
 */
@PulumiTagMarker
public class RecurrenceTriggerArgsBuilder internal constructor() {
    private var endTime: Output<String>? = null

    private var frequency: Output<Either<String, RecurrenceFrequency>>? = null

    private var interval: Output<Int>? = null

    private var schedule: Output<RecurrenceScheduleArgs>? = null

    private var startTime: Output<String>? = null

    private var timeZone: Output<String>? = null

    private var triggerType: Output<String>? = null

    /**
     * @param value Specifies end time of schedule in ISO 8601, but without a UTC offset. Refer https://en.wikipedia.org/wiki/ISO_8601.
     * Recommented format would be "2022-06-01T00:00:01"
     * If not present, the schedule will run indefinitely
     */
    @JvmName("edlbupxmhelahvqt")
    public suspend fun endTime(`value`: Output<String>) {
        this.endTime = value
    }

    /**
     * @param value [Required] The frequency to trigger schedule.
     */
    @JvmName("bclwyiahgsbtcncb")
    public suspend fun frequency(`value`: Output<Either<String, RecurrenceFrequency>>) {
        this.frequency = value
    }

    /**
     * @param value [Required] Specifies schedule interval in conjunction with frequency
     */
    @JvmName("marqpojdcjimduud")
    public suspend fun interval(`value`: Output<Int>) {
        this.interval = value
    }

    /**
     * @param value The recurrence schedule.
     */
    @JvmName("cmtkgnncnjtlbixh")
    public suspend fun schedule(`value`: Output<RecurrenceScheduleArgs>) {
        this.schedule = value
    }

    /**
     * @param value Specifies start time of schedule in ISO 8601 format, but without a UTC offset.
     */
    @JvmName("cpovpxbunjjvlyai")
    public suspend fun startTime(`value`: Output<String>) {
        this.startTime = value
    }

    /**
     * @param value Specifies time zone in which the schedule runs.
     * TimeZone should follow Windows time zone format. Refer: https://docs.microsoft.com/en-us/windows-hardware/manufacture/desktop/default-time-zones?view=windows-11
     */
    @JvmName("dlrinueowobcbcjl")
    public suspend fun timeZone(`value`: Output<String>) {
        this.timeZone = value
    }

    /**
     * @param value
     * Expected value is 'Recurrence'.
     */
    @JvmName("ordcingeiglfjwni")
    public suspend fun triggerType(`value`: Output<String>) {
        this.triggerType = value
    }

    /**
     * @param value Specifies end time of schedule in ISO 8601, but without a UTC offset. Refer https://en.wikipedia.org/wiki/ISO_8601.
     * Recommented format would be "2022-06-01T00:00:01"
     * If not present, the schedule will run indefinitely
     */
    @JvmName("jwcquqnxswbwqivg")
    public suspend fun endTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endTime = mapped
    }

    /**
     * @param value [Required] The frequency to trigger schedule.
     */
    @JvmName("ejohuhulumsgfdsx")
    public suspend fun frequency(`value`: Either<String, RecurrenceFrequency>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.frequency = mapped
    }

    /**
     * @param value [Required] The frequency to trigger schedule.
     */
    @JvmName("ipveaylimrcvqedt")
    public fun frequency(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RecurrenceFrequency>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.frequency = mapped
    }

    /**
     * @param value [Required] The frequency to trigger schedule.
     */
    @JvmName("hmdemytfulgnjgis")
    public fun frequency(`value`: RecurrenceFrequency) {
        val toBeMapped = Either.ofRight<String, RecurrenceFrequency>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.frequency = mapped
    }

    /**
     * @param value [Required] Specifies schedule interval in conjunction with frequency
     */
    @JvmName("belvyfagpljvvksv")
    public suspend fun interval(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.interval = mapped
    }

    /**
     * @param value The recurrence schedule.
     */
    @JvmName("wtxnwsypiyrfiijv")
    public suspend fun schedule(`value`: RecurrenceScheduleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schedule = mapped
    }

    /**
     * @param argument The recurrence schedule.
     */
    @JvmName("qqrmryqnydkamlrs")
    public suspend fun schedule(argument: suspend RecurrenceScheduleArgsBuilder.() -> Unit) {
        val toBeMapped = RecurrenceScheduleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.schedule = mapped
    }

    /**
     * @param value Specifies start time of schedule in ISO 8601 format, but without a UTC offset.
     */
    @JvmName("jbxqelyairfwdgou")
    public suspend fun startTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startTime = mapped
    }

    /**
     * @param value Specifies time zone in which the schedule runs.
     * TimeZone should follow Windows time zone format. Refer: https://docs.microsoft.com/en-us/windows-hardware/manufacture/desktop/default-time-zones?view=windows-11
     */
    @JvmName("edkdlxjubqatbtwi")
    public suspend fun timeZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeZone = mapped
    }

    /**
     * @param value
     * Expected value is 'Recurrence'.
     */
    @JvmName("ctulqkbwbxlmuevt")
    public suspend fun triggerType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.triggerType = mapped
    }

    internal fun build(): RecurrenceTriggerArgs = RecurrenceTriggerArgs(
        endTime = endTime,
        frequency = frequency ?: throw PulumiNullFieldException("frequency"),
        interval = interval ?: throw PulumiNullFieldException("interval"),
        schedule = schedule,
        startTime = startTime,
        timeZone = timeZone,
        triggerType = triggerType ?: throw PulumiNullFieldException("triggerType"),
    )
}
