@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.RegistryRegionArmDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Details for each region the registry is in
 * @property acrDetails List of ACR accounts
 * @property location The location where the registry exists
 * @property storageAccountDetails List of storage accounts
 */
public data class RegistryRegionArmDetailsArgs(
    public val acrDetails: Output<List<AcrDetailsArgs>>? = null,
    public val location: Output<String>? = null,
    public val storageAccountDetails: Output<List<StorageAccountDetailsArgs>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.RegistryRegionArmDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.RegistryRegionArmDetailsArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.RegistryRegionArmDetailsArgs.builder()
            .acrDetails(
                acrDetails?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .storageAccountDetails(
                storageAccountDetails?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [RegistryRegionArmDetailsArgs].
 */
@PulumiTagMarker
public class RegistryRegionArmDetailsArgsBuilder internal constructor() {
    private var acrDetails: Output<List<AcrDetailsArgs>>? = null

    private var location: Output<String>? = null

    private var storageAccountDetails: Output<List<StorageAccountDetailsArgs>>? = null

    /**
     * @param value List of ACR accounts
     */
    @JvmName("vcjevdqyvkbbsckf")
    public suspend fun acrDetails(`value`: Output<List<AcrDetailsArgs>>) {
        this.acrDetails = value
    }

    @JvmName("mdsmhynqkvqtqmim")
    public suspend fun acrDetails(vararg values: Output<AcrDetailsArgs>) {
        this.acrDetails = Output.all(values.asList())
    }

    /**
     * @param values List of ACR accounts
     */
    @JvmName("hoxfhypriljbfjnw")
    public suspend fun acrDetails(values: List<Output<AcrDetailsArgs>>) {
        this.acrDetails = Output.all(values)
    }

    /**
     * @param value The location where the registry exists
     */
    @JvmName("qwrivrnjgvkupfdy")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value List of storage accounts
     */
    @JvmName("bflheftonekxrwmy")
    public suspend fun storageAccountDetails(`value`: Output<List<StorageAccountDetailsArgs>>) {
        this.storageAccountDetails = value
    }

    @JvmName("plqkbnspbeqkqttn")
    public suspend fun storageAccountDetails(vararg values: Output<StorageAccountDetailsArgs>) {
        this.storageAccountDetails = Output.all(values.asList())
    }

    /**
     * @param values List of storage accounts
     */
    @JvmName("mbknaowugosijtsn")
    public suspend fun storageAccountDetails(values: List<Output<StorageAccountDetailsArgs>>) {
        this.storageAccountDetails = Output.all(values)
    }

    /**
     * @param value List of ACR accounts
     */
    @JvmName("lxkomqktdommjqmy")
    public suspend fun acrDetails(`value`: List<AcrDetailsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acrDetails = mapped
    }

    /**
     * @param argument List of ACR accounts
     */
    @JvmName("pskdnjcyesuvylfv")
    public suspend fun acrDetails(argument: List<suspend AcrDetailsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { AcrDetailsArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.acrDetails = mapped
    }

    /**
     * @param argument List of ACR accounts
     */
    @JvmName("yjevdiwkavonvivg")
    public suspend fun acrDetails(vararg argument: suspend AcrDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { AcrDetailsArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.acrDetails = mapped
    }

    /**
     * @param argument List of ACR accounts
     */
    @JvmName("namhwnnjaeqwomxm")
    public suspend fun acrDetails(argument: suspend AcrDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AcrDetailsArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.acrDetails = mapped
    }

    /**
     * @param values List of ACR accounts
     */
    @JvmName("cmgbixrbwgphsnsv")
    public suspend fun acrDetails(vararg values: AcrDetailsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.acrDetails = mapped
    }

    /**
     * @param value The location where the registry exists
     */
    @JvmName("ensopuvneobhbsyq")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value List of storage accounts
     */
    @JvmName("pfahunflwgmxmlvs")
    public suspend fun storageAccountDetails(`value`: List<StorageAccountDetailsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountDetails = mapped
    }

    /**
     * @param argument List of storage accounts
     */
    @JvmName("bmhnscvbntnyeaxm")
    public suspend fun storageAccountDetails(argument: List<suspend StorageAccountDetailsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            StorageAccountDetailsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.storageAccountDetails = mapped
    }

    /**
     * @param argument List of storage accounts
     */
    @JvmName("mmhnddsjxmguavef")
    public suspend fun storageAccountDetails(vararg argument: suspend StorageAccountDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            StorageAccountDetailsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.storageAccountDetails = mapped
    }

    /**
     * @param argument List of storage accounts
     */
    @JvmName("ymsrhnnsnpdysrbo")
    public suspend fun storageAccountDetails(argument: suspend StorageAccountDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(StorageAccountDetailsArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.storageAccountDetails = mapped
    }

    /**
     * @param values List of storage accounts
     */
    @JvmName("xikwvnsccutcrvkf")
    public suspend fun storageAccountDetails(vararg values: StorageAccountDetailsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageAccountDetails = mapped
    }

    internal fun build(): RegistryRegionArmDetailsArgs = RegistryRegionArmDetailsArgs(
        acrDetails = acrDetails,
        location = location,
        storageAccountDetails = storageAccountDetails,
    )
}
