@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.RegressionArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.LogVerbosity
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.RegressionPrimaryMetrics
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Regression task in AutoML Table vertical.
 * @property cvSplitColumnNames Columns to use for CVSplit data.
 * @property featurizationSettings Featurization inputs needed for AutoML job.
 * @property limitSettings Execution constraints for AutoMLJob.
 * @property logVerbosity Log verbosity for the job.
 * @property nCrossValidations Number of cross validation folds to be applied on training dataset
 * when validation dataset is not provided.
 * @property primaryMetric Primary metric for regression task.
 * @property targetColumnName Target column name: This is prediction values column.
 * Also known as label column name in context of classification tasks.
 * @property taskType AutoMLJob Task type.
 * Expected value is 'Regression'.
 * @property testData Test data input.
 * @property testDataSize The fraction of test dataset that needs to be set aside for validation purpose.
 * Values between (0.0 , 1.0)
 * Applied when validation dataset is not provided.
 * @property trainingData [Required] Training data input.
 * @property trainingSettings Inputs for training phase for an AutoML Job.
 * @property validationData Validation data inputs.
 * @property validationDataSize The fraction of training dataset that needs to be set aside for validation purpose.
 * Values between (0.0 , 1.0)
 * Applied when validation dataset is not provided.
 * @property weightColumnName The name of the sample weight column. Automated ML supports a weighted column as an input, causing rows in the data to be weighted up or down.
 */
public data class RegressionArgs(
    public val cvSplitColumnNames: Output<List<String>>? = null,
    public val featurizationSettings: Output<TableVerticalFeaturizationSettingsArgs>? = null,
    public val limitSettings: Output<TableVerticalLimitSettingsArgs>? = null,
    public val logVerbosity: Output<Either<String, LogVerbosity>>? = null,
    public val nCrossValidations: Output<Either<AutoNCrossValidationsArgs, CustomNCrossValidationsArgs>>? = null,
    public val primaryMetric: Output<Either<String, RegressionPrimaryMetrics>>? = null,
    public val targetColumnName: Output<String>? = null,
    public val taskType: Output<String>,
    public val testData: Output<MLTableJobInputArgs>? = null,
    public val testDataSize: Output<Double>? = null,
    public val trainingData: Output<MLTableJobInputArgs>,
    public val trainingSettings: Output<RegressionTrainingSettingsArgs>? = null,
    public val validationData: Output<MLTableJobInputArgs>? = null,
    public val validationDataSize: Output<Double>? = null,
    public val weightColumnName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.RegressionArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.RegressionArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.RegressionArgs.builder()
            .cvSplitColumnNames(cvSplitColumnNames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .featurizationSettings(
                featurizationSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .limitSettings(limitSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .logVerbosity(
                logVerbosity?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .nCrossValidations(
                nCrossValidations?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .primaryMetric(
                primaryMetric?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .targetColumnName(targetColumnName?.applyValue({ args0 -> args0 }))
            .taskType(taskType.applyValue({ args0 -> args0 }))
            .testData(testData?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .testDataSize(testDataSize?.applyValue({ args0 -> args0 }))
            .trainingData(trainingData.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .trainingSettings(trainingSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .validationData(validationData?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .validationDataSize(validationDataSize?.applyValue({ args0 -> args0 }))
            .weightColumnName(weightColumnName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RegressionArgs].
 */
@PulumiTagMarker
public class RegressionArgsBuilder internal constructor() {
    private var cvSplitColumnNames: Output<List<String>>? = null

    private var featurizationSettings: Output<TableVerticalFeaturizationSettingsArgs>? = null

    private var limitSettings: Output<TableVerticalLimitSettingsArgs>? = null

    private var logVerbosity: Output<Either<String, LogVerbosity>>? = null

    private var nCrossValidations:
        Output<Either<AutoNCrossValidationsArgs, CustomNCrossValidationsArgs>>? = null

    private var primaryMetric: Output<Either<String, RegressionPrimaryMetrics>>? = null

    private var targetColumnName: Output<String>? = null

    private var taskType: Output<String>? = null

    private var testData: Output<MLTableJobInputArgs>? = null

    private var testDataSize: Output<Double>? = null

    private var trainingData: Output<MLTableJobInputArgs>? = null

    private var trainingSettings: Output<RegressionTrainingSettingsArgs>? = null

    private var validationData: Output<MLTableJobInputArgs>? = null

    private var validationDataSize: Output<Double>? = null

    private var weightColumnName: Output<String>? = null

    /**
     * @param value Columns to use for CVSplit data.
     */
    @JvmName("rfopijsxvpqqcibo")
    public suspend fun cvSplitColumnNames(`value`: Output<List<String>>) {
        this.cvSplitColumnNames = value
    }

    @JvmName("vlggylopqykluhkc")
    public suspend fun cvSplitColumnNames(vararg values: Output<String>) {
        this.cvSplitColumnNames = Output.all(values.asList())
    }

    /**
     * @param values Columns to use for CVSplit data.
     */
    @JvmName("vclgloebeukqiycv")
    public suspend fun cvSplitColumnNames(values: List<Output<String>>) {
        this.cvSplitColumnNames = Output.all(values)
    }

    /**
     * @param value Featurization inputs needed for AutoML job.
     */
    @JvmName("fgckcjjcvvrqmcnn")
    public suspend fun featurizationSettings(`value`: Output<TableVerticalFeaturizationSettingsArgs>) {
        this.featurizationSettings = value
    }

    /**
     * @param value Execution constraints for AutoMLJob.
     */
    @JvmName("xvtfighhlhuoayjn")
    public suspend fun limitSettings(`value`: Output<TableVerticalLimitSettingsArgs>) {
        this.limitSettings = value
    }

    /**
     * @param value Log verbosity for the job.
     */
    @JvmName("tamsypjtyixwaswn")
    public suspend fun logVerbosity(`value`: Output<Either<String, LogVerbosity>>) {
        this.logVerbosity = value
    }

    /**
     * @param value Number of cross validation folds to be applied on training dataset
     * when validation dataset is not provided.
     */
    @JvmName("vveewcumyayofddt")
    public suspend fun nCrossValidations(`value`: Output<Either<AutoNCrossValidationsArgs, CustomNCrossValidationsArgs>>) {
        this.nCrossValidations = value
    }

    /**
     * @param value Primary metric for regression task.
     */
    @JvmName("olwaitbhttvnvony")
    public suspend fun primaryMetric(`value`: Output<Either<String, RegressionPrimaryMetrics>>) {
        this.primaryMetric = value
    }

    /**
     * @param value Target column name: This is prediction values column.
     * Also known as label column name in context of classification tasks.
     */
    @JvmName("ebdpoaaciltckcnn")
    public suspend fun targetColumnName(`value`: Output<String>) {
        this.targetColumnName = value
    }

    /**
     * @param value AutoMLJob Task type.
     * Expected value is 'Regression'.
     */
    @JvmName("ookkypdikniixklw")
    public suspend fun taskType(`value`: Output<String>) {
        this.taskType = value
    }

    /**
     * @param value Test data input.
     */
    @JvmName("eokemimxnhyyfbtw")
    public suspend fun testData(`value`: Output<MLTableJobInputArgs>) {
        this.testData = value
    }

    /**
     * @param value The fraction of test dataset that needs to be set aside for validation purpose.
     * Values between (0.0 , 1.0)
     * Applied when validation dataset is not provided.
     */
    @JvmName("xfvrtblmlwkbpoai")
    public suspend fun testDataSize(`value`: Output<Double>) {
        this.testDataSize = value
    }

    /**
     * @param value [Required] Training data input.
     */
    @JvmName("sukittiliduktbxf")
    public suspend fun trainingData(`value`: Output<MLTableJobInputArgs>) {
        this.trainingData = value
    }

    /**
     * @param value Inputs for training phase for an AutoML Job.
     */
    @JvmName("viyyeprrlfttdivw")
    public suspend fun trainingSettings(`value`: Output<RegressionTrainingSettingsArgs>) {
        this.trainingSettings = value
    }

    /**
     * @param value Validation data inputs.
     */
    @JvmName("cklatbpjceybrmce")
    public suspend fun validationData(`value`: Output<MLTableJobInputArgs>) {
        this.validationData = value
    }

    /**
     * @param value The fraction of training dataset that needs to be set aside for validation purpose.
     * Values between (0.0 , 1.0)
     * Applied when validation dataset is not provided.
     */
    @JvmName("pgtjrybanjkdorxa")
    public suspend fun validationDataSize(`value`: Output<Double>) {
        this.validationDataSize = value
    }

    /**
     * @param value The name of the sample weight column. Automated ML supports a weighted column as an input, causing rows in the data to be weighted up or down.
     */
    @JvmName("vqngcjsnfqgqxnjd")
    public suspend fun weightColumnName(`value`: Output<String>) {
        this.weightColumnName = value
    }

    /**
     * @param value Columns to use for CVSplit data.
     */
    @JvmName("kfbahunbkbsxfxgw")
    public suspend fun cvSplitColumnNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cvSplitColumnNames = mapped
    }

    /**
     * @param values Columns to use for CVSplit data.
     */
    @JvmName("lvytnwjoxxlsiuvr")
    public suspend fun cvSplitColumnNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cvSplitColumnNames = mapped
    }

    /**
     * @param value Featurization inputs needed for AutoML job.
     */
    @JvmName("fgvddckpgqlafdhu")
    public suspend fun featurizationSettings(`value`: TableVerticalFeaturizationSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.featurizationSettings = mapped
    }

    /**
     * @param argument Featurization inputs needed for AutoML job.
     */
    @JvmName("rynaupjjktekatwb")
    public suspend fun featurizationSettings(argument: suspend TableVerticalFeaturizationSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = TableVerticalFeaturizationSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.featurizationSettings = mapped
    }

    /**
     * @param value Execution constraints for AutoMLJob.
     */
    @JvmName("wrtbphrqtmshenwq")
    public suspend fun limitSettings(`value`: TableVerticalLimitSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.limitSettings = mapped
    }

    /**
     * @param argument Execution constraints for AutoMLJob.
     */
    @JvmName("apmqsycgcvqqyggl")
    public suspend fun limitSettings(argument: suspend TableVerticalLimitSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = TableVerticalLimitSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.limitSettings = mapped
    }

    /**
     * @param value Log verbosity for the job.
     */
    @JvmName("kldubpbjbwijeacy")
    public suspend fun logVerbosity(`value`: Either<String, LogVerbosity>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logVerbosity = mapped
    }

    /**
     * @param value Log verbosity for the job.
     */
    @JvmName("uiamxkqfychxrncs")
    public fun logVerbosity(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LogVerbosity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logVerbosity = mapped
    }

    /**
     * @param value Log verbosity for the job.
     */
    @JvmName("fiiffpnmbstshisr")
    public fun logVerbosity(`value`: LogVerbosity) {
        val toBeMapped = Either.ofRight<String, LogVerbosity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logVerbosity = mapped
    }

    /**
     * @param value Number of cross validation folds to be applied on training dataset
     * when validation dataset is not provided.
     */
    @JvmName("aekopogbiclwuxwf")
    public suspend fun nCrossValidations(`value`: Either<AutoNCrossValidationsArgs, CustomNCrossValidationsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nCrossValidations = mapped
    }

    /**
     * @param value Number of cross validation folds to be applied on training dataset
     * when validation dataset is not provided.
     */
    @JvmName("sblfqtccfsoxtgow")
    public fun nCrossValidations(`value`: AutoNCrossValidationsArgs) {
        val toBeMapped = Either.ofLeft<AutoNCrossValidationsArgs, CustomNCrossValidationsArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nCrossValidations = mapped
    }

    /**
     * @param value Number of cross validation folds to be applied on training dataset
     * when validation dataset is not provided.
     */
    @JvmName("ddvuofmlvepoculo")
    public fun nCrossValidations(`value`: CustomNCrossValidationsArgs) {
        val toBeMapped = Either.ofRight<AutoNCrossValidationsArgs, CustomNCrossValidationsArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nCrossValidations = mapped
    }

    /**
     * @param value Primary metric for regression task.
     */
    @JvmName("cqkgyitcqkplnexm")
    public suspend fun primaryMetric(`value`: Either<String, RegressionPrimaryMetrics>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryMetric = mapped
    }

    /**
     * @param value Primary metric for regression task.
     */
    @JvmName("cgylvylotswajagi")
    public fun primaryMetric(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RegressionPrimaryMetrics>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.primaryMetric = mapped
    }

    /**
     * @param value Primary metric for regression task.
     */
    @JvmName("swlxrjvkfbipbxiq")
    public fun primaryMetric(`value`: RegressionPrimaryMetrics) {
        val toBeMapped = Either.ofRight<String, RegressionPrimaryMetrics>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.primaryMetric = mapped
    }

    /**
     * @param value Target column name: This is prediction values column.
     * Also known as label column name in context of classification tasks.
     */
    @JvmName("mjvbtrojlystqige")
    public suspend fun targetColumnName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetColumnName = mapped
    }

    /**
     * @param value AutoMLJob Task type.
     * Expected value is 'Regression'.
     */
    @JvmName("pvkjkdoertfawoeg")
    public suspend fun taskType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.taskType = mapped
    }

    /**
     * @param value Test data input.
     */
    @JvmName("tcwcjafcrygdlocw")
    public suspend fun testData(`value`: MLTableJobInputArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.testData = mapped
    }

    /**
     * @param argument Test data input.
     */
    @JvmName("yukariffweujivro")
    public suspend fun testData(argument: suspend MLTableJobInputArgsBuilder.() -> Unit) {
        val toBeMapped = MLTableJobInputArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.testData = mapped
    }

    /**
     * @param value The fraction of test dataset that needs to be set aside for validation purpose.
     * Values between (0.0 , 1.0)
     * Applied when validation dataset is not provided.
     */
    @JvmName("lgqttpqidugsoble")
    public suspend fun testDataSize(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.testDataSize = mapped
    }

    /**
     * @param value [Required] Training data input.
     */
    @JvmName("axemfaeywpdxtfso")
    public suspend fun trainingData(`value`: MLTableJobInputArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trainingData = mapped
    }

    /**
     * @param argument [Required] Training data input.
     */
    @JvmName("gfbbhfupyftpybmf")
    public suspend fun trainingData(argument: suspend MLTableJobInputArgsBuilder.() -> Unit) {
        val toBeMapped = MLTableJobInputArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.trainingData = mapped
    }

    /**
     * @param value Inputs for training phase for an AutoML Job.
     */
    @JvmName("kcwupkydaiklqbfi")
    public suspend fun trainingSettings(`value`: RegressionTrainingSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trainingSettings = mapped
    }

    /**
     * @param argument Inputs for training phase for an AutoML Job.
     */
    @JvmName("ypdfhvjbytxcascb")
    public suspend fun trainingSettings(argument: suspend RegressionTrainingSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = RegressionTrainingSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.trainingSettings = mapped
    }

    /**
     * @param value Validation data inputs.
     */
    @JvmName("jtoanfrxmrjdemex")
    public suspend fun validationData(`value`: MLTableJobInputArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validationData = mapped
    }

    /**
     * @param argument Validation data inputs.
     */
    @JvmName("akceisqugcaofapf")
    public suspend fun validationData(argument: suspend MLTableJobInputArgsBuilder.() -> Unit) {
        val toBeMapped = MLTableJobInputArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.validationData = mapped
    }

    /**
     * @param value The fraction of training dataset that needs to be set aside for validation purpose.
     * Values between (0.0 , 1.0)
     * Applied when validation dataset is not provided.
     */
    @JvmName("cvsctlmuehrmjhri")
    public suspend fun validationDataSize(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validationDataSize = mapped
    }

    /**
     * @param value The name of the sample weight column. Automated ML supports a weighted column as an input, causing rows in the data to be weighted up or down.
     */
    @JvmName("yiqicrrbdrvekpns")
    public suspend fun weightColumnName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weightColumnName = mapped
    }

    internal fun build(): RegressionArgs = RegressionArgs(
        cvSplitColumnNames = cvSplitColumnNames,
        featurizationSettings = featurizationSettings,
        limitSettings = limitSettings,
        logVerbosity = logVerbosity,
        nCrossValidations = nCrossValidations,
        primaryMetric = primaryMetric,
        targetColumnName = targetColumnName,
        taskType = taskType ?: throw PulumiNullFieldException("taskType"),
        testData = testData,
        testDataSize = testDataSize,
        trainingData = trainingData ?: throw PulumiNullFieldException("trainingData"),
        trainingSettings = trainingSettings,
        validationData = validationData,
        validationDataSize = validationDataSize,
        weightColumnName = weightColumnName,
    )
}
