@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.ScheduleArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Base definition of a schedule
 * @property action [Required] Specifies the action of the schedule
 * @property description The asset description text.
 * @property displayName Display name of schedule.
 * @property isEnabled Is the schedule enabled?
 * @property properties The asset property dictionary.
 * @property tags Tag dictionary. Tags can be added, removed, and updated.
 * @property trigger [Required] Specifies the trigger details
 */
public data class ScheduleArgs(
    public val action: Output<Either<EndpointScheduleActionArgs, JobScheduleActionArgs>>,
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val isEnabled: Output<Boolean>? = null,
    public val properties: Output<Map<String, String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val trigger: Output<Either<CronTriggerArgs, RecurrenceTriggerArgs>>,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.ScheduleArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.ScheduleArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.ScheduleArgs.builder()
            .action(
                action.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .isEnabled(isEnabled?.applyValue({ args0 -> args0 }))
            .properties(
                properties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .trigger(
                trigger.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            ).build()
}

/**
 * Builder for [ScheduleArgs].
 */
@PulumiTagMarker
public class ScheduleArgsBuilder internal constructor() {
    private var action: Output<Either<EndpointScheduleActionArgs, JobScheduleActionArgs>>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var isEnabled: Output<Boolean>? = null

    private var properties: Output<Map<String, String>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var trigger: Output<Either<CronTriggerArgs, RecurrenceTriggerArgs>>? = null

    /**
     * @param value [Required] Specifies the action of the schedule
     */
    @JvmName("cjacifqgvmliprbj")
    public suspend fun action(`value`: Output<Either<EndpointScheduleActionArgs, JobScheduleActionArgs>>) {
        this.action = value
    }

    /**
     * @param value The asset description text.
     */
    @JvmName("iqdhahustgcccrgn")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Display name of schedule.
     */
    @JvmName("bxtpbrntmgehowym")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Is the schedule enabled?
     */
    @JvmName("culkjxreutyhcxih")
    public suspend fun isEnabled(`value`: Output<Boolean>) {
        this.isEnabled = value
    }

    /**
     * @param value The asset property dictionary.
     */
    @JvmName("syimonaadlnypkel")
    public suspend fun properties(`value`: Output<Map<String, String>>) {
        this.properties = value
    }

    /**
     * @param value Tag dictionary. Tags can be added, removed, and updated.
     */
    @JvmName("odublxklerwldtth")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value [Required] Specifies the trigger details
     */
    @JvmName("teggkirdovrmwwcr")
    public suspend fun trigger(`value`: Output<Either<CronTriggerArgs, RecurrenceTriggerArgs>>) {
        this.trigger = value
    }

    /**
     * @param value [Required] Specifies the action of the schedule
     */
    @JvmName("oqgwymebxiqstcks")
    public suspend fun action(`value`: Either<EndpointScheduleActionArgs, JobScheduleActionArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value [Required] Specifies the action of the schedule
     */
    @JvmName("frjoyfvkcpnvbfgy")
    public fun action(`value`: EndpointScheduleActionArgs) {
        val toBeMapped = Either.ofLeft<EndpointScheduleActionArgs, JobScheduleActionArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value [Required] Specifies the action of the schedule
     */
    @JvmName("pivhtyliffcbyxxu")
    public fun action(`value`: JobScheduleActionArgs) {
        val toBeMapped = Either.ofRight<EndpointScheduleActionArgs, JobScheduleActionArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value The asset description text.
     */
    @JvmName("efqnifnjrggcbvwx")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Display name of schedule.
     */
    @JvmName("ykctecrdrbhpjaku")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Is the schedule enabled?
     */
    @JvmName("pldusfmkecahnnyl")
    public suspend fun isEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isEnabled = mapped
    }

    /**
     * @param value The asset property dictionary.
     */
    @JvmName("tsbvuouillbootbt")
    public suspend fun properties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param values The asset property dictionary.
     */
    @JvmName("ojrkrssjouopkeef")
    public fun properties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value Tag dictionary. Tags can be added, removed, and updated.
     */
    @JvmName("ufghvgxlvnkautgi")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tag dictionary. Tags can be added, removed, and updated.
     */
    @JvmName("kftvjqkykfxklvty")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value [Required] Specifies the trigger details
     */
    @JvmName("wohqfdrypkgscijc")
    public suspend fun trigger(`value`: Either<CronTriggerArgs, RecurrenceTriggerArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trigger = mapped
    }

    /**
     * @param value [Required] Specifies the trigger details
     */
    @JvmName("swdsomwrgqfulkmd")
    public fun trigger(`value`: CronTriggerArgs) {
        val toBeMapped = Either.ofLeft<CronTriggerArgs, RecurrenceTriggerArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trigger = mapped
    }

    /**
     * @param value [Required] Specifies the trigger details
     */
    @JvmName("aunshuvithfxjely")
    public fun trigger(`value`: RecurrenceTriggerArgs) {
        val toBeMapped = Either.ofRight<CronTriggerArgs, RecurrenceTriggerArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trigger = mapped
    }

    internal fun build(): ScheduleArgs = ScheduleArgs(
        action = action ?: throw PulumiNullFieldException("action"),
        description = description,
        displayName = displayName,
        isEnabled = isEnabled,
        properties = properties,
        tags = tags,
        trigger = trigger ?: throw PulumiNullFieldException("trigger"),
    )
}
