@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.ScheduleBaseArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.ScheduleProvisioningState
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.ScheduleStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property id A system assigned id for the schedule.
 * @property provisioningStatus The current deployment state of schedule.
 * @property status Is the schedule enabled or disabled?
 */
public data class ScheduleBaseArgs(
    public val id: Output<String>? = null,
    public val provisioningStatus: Output<Either<String, ScheduleProvisioningState>>? = null,
    public val status: Output<Either<String, ScheduleStatus>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.ScheduleBaseArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.ScheduleBaseArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.ScheduleBaseArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .provisioningStatus(
                provisioningStatus?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .status(
                status?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ScheduleBaseArgs].
 */
@PulumiTagMarker
public class ScheduleBaseArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var provisioningStatus: Output<Either<String, ScheduleProvisioningState>>? = null

    private var status: Output<Either<String, ScheduleStatus>>? = null

    /**
     * @param value A system assigned id for the schedule.
     */
    @JvmName("hisoklkexxobwous")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The current deployment state of schedule.
     */
    @JvmName("aoxreejrhqhyowtd")
    public suspend fun provisioningStatus(`value`: Output<Either<String, ScheduleProvisioningState>>) {
        this.provisioningStatus = value
    }

    /**
     * @param value Is the schedule enabled or disabled?
     */
    @JvmName("mktqprccryuwpucw")
    public suspend fun status(`value`: Output<Either<String, ScheduleStatus>>) {
        this.status = value
    }

    /**
     * @param value A system assigned id for the schedule.
     */
    @JvmName("etpbwigqaqmbqkpf")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The current deployment state of schedule.
     */
    @JvmName("ejhhidxivjanypev")
    public suspend fun provisioningStatus(`value`: Either<String, ScheduleProvisioningState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningStatus = mapped
    }

    /**
     * @param value The current deployment state of schedule.
     */
    @JvmName("hgfjylqjjphpheeq")
    public fun provisioningStatus(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ScheduleProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningStatus = mapped
    }

    /**
     * @param value The current deployment state of schedule.
     */
    @JvmName("ostlsietmsmbngqt")
    public fun provisioningStatus(`value`: ScheduleProvisioningState) {
        val toBeMapped = Either.ofRight<String, ScheduleProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningStatus = mapped
    }

    /**
     * @param value Is the schedule enabled or disabled?
     */
    @JvmName("doncnbqlujncdadc")
    public suspend fun status(`value`: Either<String, ScheduleStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Is the schedule enabled or disabled?
     */
    @JvmName("ieuiwgvxqpqmxhxb")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ScheduleStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Is the schedule enabled or disabled?
     */
    @JvmName("jlbdjdtddargevfg")
    public fun status(`value`: ScheduleStatus) {
        val toBeMapped = Either.ofRight<String, ScheduleStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): ScheduleBaseArgs = ScheduleBaseArgs(
        id = id,
        provisioningStatus = provisioningStatus,
        status = status,
    )
}
