@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.SecretConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Secret Configuration definition.
 * @property uri Secret Uri.
 * Sample Uri : https://myvault.vault.azure.net/secrets/mysecretname/secretversion
 * @property workspaceSecretName Name of secret in workspace key vault.
 */
public data class SecretConfigurationArgs(
    public val uri: Output<String>? = null,
    public val workspaceSecretName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.SecretConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.SecretConfigurationArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.SecretConfigurationArgs.builder()
            .uri(uri?.applyValue({ args0 -> args0 }))
            .workspaceSecretName(workspaceSecretName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SecretConfigurationArgs].
 */
@PulumiTagMarker
public class SecretConfigurationArgsBuilder internal constructor() {
    private var uri: Output<String>? = null

    private var workspaceSecretName: Output<String>? = null

    /**
     * @param value Secret Uri.
     * Sample Uri : https://myvault.vault.azure.net/secrets/mysecretname/secretversion
     */
    @JvmName("gdxyrprgnsfobbeb")
    public suspend fun uri(`value`: Output<String>) {
        this.uri = value
    }

    /**
     * @param value Name of secret in workspace key vault.
     */
    @JvmName("fepwwektcruoamgr")
    public suspend fun workspaceSecretName(`value`: Output<String>) {
        this.workspaceSecretName = value
    }

    /**
     * @param value Secret Uri.
     * Sample Uri : https://myvault.vault.azure.net/secrets/mysecretname/secretversion
     */
    @JvmName("pbkkqbiomwrfulvt")
    public suspend fun uri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uri = mapped
    }

    /**
     * @param value Name of secret in workspace key vault.
     */
    @JvmName("ldqwnqbayijhxhpf")
    public suspend fun workspaceSecretName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceSecretName = mapped
    }

    internal fun build(): SecretConfigurationArgs = SecretConfigurationArgs(
        uri = uri,
        workspaceSecretName = workspaceSecretName,
    )
}
