@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.ServerlessEndpointArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.ServerlessInferenceEndpointAuthMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property authMode Specifies the authentication mode for the Serverless endpoint.
 * @property capacityReservation Optional capacity reservation information for the endpoint. When specified, the Serverless Endpoint
 * will be allocated capacity from the specified capacity reservation group.
 * @property offer [Required] The publisher-defined Serverless Offer to provision the endpoint with.
 */
public data class ServerlessEndpointArgs(
    public val authMode: Output<Either<String, ServerlessInferenceEndpointAuthMode>>? = null,
    public val capacityReservation: Output<ServerlessEndpointCapacityReservationArgs>? = null,
    public val offer: Output<ServerlessOfferArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.ServerlessEndpointArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.ServerlessEndpointArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.ServerlessEndpointArgs.builder()
            .authMode(
                authMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .capacityReservation(
                capacityReservation?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .offer(offer.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ServerlessEndpointArgs].
 */
@PulumiTagMarker
public class ServerlessEndpointArgsBuilder internal constructor() {
    private var authMode: Output<Either<String, ServerlessInferenceEndpointAuthMode>>? = null

    private var capacityReservation: Output<ServerlessEndpointCapacityReservationArgs>? = null

    private var offer: Output<ServerlessOfferArgs>? = null

    /**
     * @param value Specifies the authentication mode for the Serverless endpoint.
     */
    @JvmName("fgvfnwnjigktxrnv")
    public suspend fun authMode(`value`: Output<Either<String, ServerlessInferenceEndpointAuthMode>>) {
        this.authMode = value
    }

    /**
     * @param value Optional capacity reservation information for the endpoint. When specified, the Serverless Endpoint
     * will be allocated capacity from the specified capacity reservation group.
     */
    @JvmName("dtomjhdqeygfcspt")
    public suspend fun capacityReservation(`value`: Output<ServerlessEndpointCapacityReservationArgs>) {
        this.capacityReservation = value
    }

    /**
     * @param value [Required] The publisher-defined Serverless Offer to provision the endpoint with.
     */
    @JvmName("ryofuuupuvrjvlsa")
    public suspend fun offer(`value`: Output<ServerlessOfferArgs>) {
        this.offer = value
    }

    /**
     * @param value Specifies the authentication mode for the Serverless endpoint.
     */
    @JvmName("lnitkjxfmmwbcafr")
    public suspend fun authMode(`value`: Either<String, ServerlessInferenceEndpointAuthMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authMode = mapped
    }

    /**
     * @param value Specifies the authentication mode for the Serverless endpoint.
     */
    @JvmName("jypitdafrrvytryv")
    public fun authMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ServerlessInferenceEndpointAuthMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authMode = mapped
    }

    /**
     * @param value Specifies the authentication mode for the Serverless endpoint.
     */
    @JvmName("sejbwyqqqiauanmw")
    public fun authMode(`value`: ServerlessInferenceEndpointAuthMode) {
        val toBeMapped = Either.ofRight<String, ServerlessInferenceEndpointAuthMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authMode = mapped
    }

    /**
     * @param value Optional capacity reservation information for the endpoint. When specified, the Serverless Endpoint
     * will be allocated capacity from the specified capacity reservation group.
     */
    @JvmName("gfdmpxeisgiahklv")
    public suspend fun capacityReservation(`value`: ServerlessEndpointCapacityReservationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacityReservation = mapped
    }

    /**
     * @param argument Optional capacity reservation information for the endpoint. When specified, the Serverless Endpoint
     * will be allocated capacity from the specified capacity reservation group.
     */
    @JvmName("fxqnpnqqwjnhluda")
    public suspend fun capacityReservation(argument: suspend ServerlessEndpointCapacityReservationArgsBuilder.() -> Unit) {
        val toBeMapped = ServerlessEndpointCapacityReservationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.capacityReservation = mapped
    }

    /**
     * @param value [Required] The publisher-defined Serverless Offer to provision the endpoint with.
     */
    @JvmName("hpoiwuetcblfvkvd")
    public suspend fun offer(`value`: ServerlessOfferArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.offer = mapped
    }

    /**
     * @param argument [Required] The publisher-defined Serverless Offer to provision the endpoint with.
     */
    @JvmName("lejmpcbmnqufycpx")
    public suspend fun offer(argument: suspend ServerlessOfferArgsBuilder.() -> Unit) {
        val toBeMapped = ServerlessOfferArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.offer = mapped
    }

    internal fun build(): ServerlessEndpointArgs = ServerlessEndpointArgs(
        authMode = authMode,
        capacityReservation = capacityReservation,
        offer = offer ?: throw PulumiNullFieldException("offer"),
    )
}
