@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.ServerlessOfferArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property offerName [Required] The name of the Serverless Offer
 * @property publisher [Required] Publisher name of the Serverless Offer
 */
public data class ServerlessOfferArgs(
    public val offerName: Output<String>,
    public val publisher: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.ServerlessOfferArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.ServerlessOfferArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.ServerlessOfferArgs.builder()
            .offerName(offerName.applyValue({ args0 -> args0 }))
            .publisher(publisher.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServerlessOfferArgs].
 */
@PulumiTagMarker
public class ServerlessOfferArgsBuilder internal constructor() {
    private var offerName: Output<String>? = null

    private var publisher: Output<String>? = null

    /**
     * @param value [Required] The name of the Serverless Offer
     */
    @JvmName("linignrenhrtmssq")
    public suspend fun offerName(`value`: Output<String>) {
        this.offerName = value
    }

    /**
     * @param value [Required] Publisher name of the Serverless Offer
     */
    @JvmName("ocfpabanbcoxrxyp")
    public suspend fun publisher(`value`: Output<String>) {
        this.publisher = value
    }

    /**
     * @param value [Required] The name of the Serverless Offer
     */
    @JvmName("tpkobuwjdxgiwvve")
    public suspend fun offerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.offerName = mapped
    }

    /**
     * @param value [Required] Publisher name of the Serverless Offer
     */
    @JvmName("atcjhwkgwmsdtvhw")
    public suspend fun publisher(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publisher = mapped
    }

    internal fun build(): ServerlessOfferArgs = ServerlessOfferArgs(
        offerName = offerName ?: throw PulumiNullFieldException("offerName"),
        publisher = publisher ?: throw PulumiNullFieldException("publisher"),
    )
}
