@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.ServicePrincipalDatastoreSecretsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Datastore Service Principal secrets.
 * @property clientSecret Service principal secret.
 * @property secretsType Enum to determine the datastore secrets type.
 * Expected value is 'ServicePrincipal'.
 */
public data class ServicePrincipalDatastoreSecretsArgs(
    public val clientSecret: Output<String>? = null,
    public val secretsType: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.ServicePrincipalDatastoreSecretsArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.ServicePrincipalDatastoreSecretsArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.ServicePrincipalDatastoreSecretsArgs.builder()
            .clientSecret(clientSecret?.applyValue({ args0 -> args0 }))
            .secretsType(secretsType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServicePrincipalDatastoreSecretsArgs].
 */
@PulumiTagMarker
public class ServicePrincipalDatastoreSecretsArgsBuilder internal constructor() {
    private var clientSecret: Output<String>? = null

    private var secretsType: Output<String>? = null

    /**
     * @param value Service principal secret.
     */
    @JvmName("jdgssrmnqivplwhj")
    public suspend fun clientSecret(`value`: Output<String>) {
        this.clientSecret = value
    }

    /**
     * @param value Enum to determine the datastore secrets type.
     * Expected value is 'ServicePrincipal'.
     */
    @JvmName("sfjryuhsjkslmeiq")
    public suspend fun secretsType(`value`: Output<String>) {
        this.secretsType = value
    }

    /**
     * @param value Service principal secret.
     */
    @JvmName("lrauagiwuijmgrdg")
    public suspend fun clientSecret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientSecret = mapped
    }

    /**
     * @param value Enum to determine the datastore secrets type.
     * Expected value is 'ServicePrincipal'.
     */
    @JvmName("bppfysubvqkbwbnh")
    public suspend fun secretsType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secretsType = mapped
    }

    internal fun build(): ServicePrincipalDatastoreSecretsArgs = ServicePrincipalDatastoreSecretsArgs(
        clientSecret = clientSecret,
        secretsType = secretsType ?: throw PulumiNullFieldException("secretsType"),
    )
}
