@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.SslConfigurationArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.SslConfigStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The ssl configuration for scoring
 * @property cert Cert data
 * @property cname CNAME of the cert
 * @property key Key data
 * @property leafDomainLabel Leaf domain label of public endpoint
 * @property overwriteExistingDomain Indicates whether to overwrite existing domain label.
 * @property status Enable or disable ssl for scoring
 */
public data class SslConfigurationArgs(
    public val cert: Output<String>? = null,
    public val cname: Output<String>? = null,
    public val key: Output<String>? = null,
    public val leafDomainLabel: Output<String>? = null,
    public val overwriteExistingDomain: Output<Boolean>? = null,
    public val status: Output<Either<String, SslConfigStatus>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.SslConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.SslConfigurationArgs = com.pulumi.azurenative.machinelearningservices.inputs.SslConfigurationArgs.builder()
        .cert(cert?.applyValue({ args0 -> args0 }))
        .cname(cname?.applyValue({ args0 -> args0 }))
        .key(key?.applyValue({ args0 -> args0 }))
        .leafDomainLabel(leafDomainLabel?.applyValue({ args0 -> args0 }))
        .overwriteExistingDomain(overwriteExistingDomain?.applyValue({ args0 -> args0 }))
        .status(
            status?.applyValue({ args0 ->
                args0.transform({ args0 -> args0 }, { args0 ->
                    args0.let({ args0 -> args0.toJava() })
                })
            }),
        ).build()
}

/**
 * Builder for [SslConfigurationArgs].
 */
@PulumiTagMarker
public class SslConfigurationArgsBuilder internal constructor() {
    private var cert: Output<String>? = null

    private var cname: Output<String>? = null

    private var key: Output<String>? = null

    private var leafDomainLabel: Output<String>? = null

    private var overwriteExistingDomain: Output<Boolean>? = null

    private var status: Output<Either<String, SslConfigStatus>>? = null

    /**
     * @param value Cert data
     */
    @JvmName("bdlklagopiwkcnxj")
    public suspend fun cert(`value`: Output<String>) {
        this.cert = value
    }

    /**
     * @param value CNAME of the cert
     */
    @JvmName("xaultpdjgcfxuyxt")
    public suspend fun cname(`value`: Output<String>) {
        this.cname = value
    }

    /**
     * @param value Key data
     */
    @JvmName("dgqdrogogcvspmtk")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value Leaf domain label of public endpoint
     */
    @JvmName("steiwscbnvnallrw")
    public suspend fun leafDomainLabel(`value`: Output<String>) {
        this.leafDomainLabel = value
    }

    /**
     * @param value Indicates whether to overwrite existing domain label.
     */
    @JvmName("otwngqasdcfkrsov")
    public suspend fun overwriteExistingDomain(`value`: Output<Boolean>) {
        this.overwriteExistingDomain = value
    }

    /**
     * @param value Enable or disable ssl for scoring
     */
    @JvmName("svwmxkwknppcfflm")
    public suspend fun status(`value`: Output<Either<String, SslConfigStatus>>) {
        this.status = value
    }

    /**
     * @param value Cert data
     */
    @JvmName("opdhbyqnacgoakkv")
    public suspend fun cert(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cert = mapped
    }

    /**
     * @param value CNAME of the cert
     */
    @JvmName("mpmpytfqhlteuxbs")
    public suspend fun cname(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cname = mapped
    }

    /**
     * @param value Key data
     */
    @JvmName("veomoxojckismjws")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value Leaf domain label of public endpoint
     */
    @JvmName("sntvfkvtndqkeudd")
    public suspend fun leafDomainLabel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.leafDomainLabel = mapped
    }

    /**
     * @param value Indicates whether to overwrite existing domain label.
     */
    @JvmName("ixwcvpisanqjtvfm")
    public suspend fun overwriteExistingDomain(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.overwriteExistingDomain = mapped
    }

    /**
     * @param value Enable or disable ssl for scoring
     */
    @JvmName("dejxhnkrdblkocte")
    public suspend fun status(`value`: Either<String, SslConfigStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Enable or disable ssl for scoring
     */
    @JvmName("cjtcutfahxufxjqs")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SslConfigStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Enable or disable ssl for scoring
     */
    @JvmName("uobgwxkfcaohnjlc")
    public fun status(`value`: SslConfigStatus) {
        val toBeMapped = Either.ofRight<String, SslConfigStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): SslConfigurationArgs = SslConfigurationArgs(
        cert = cert,
        cname = cname,
        key = key,
        leafDomainLabel = leafDomainLabel,
        overwriteExistingDomain = overwriteExistingDomain,
        status = status,
    )
}
