@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.StackEnsembleSettingsArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.StackMetaLearnerType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Advances setting to customize StackEnsemble run.
 * @property stackMetaLearnerKWargs Optional parameters to pass to the initializer of the meta-learner.
 * @property stackMetaLearnerTrainPercentage Specifies the proportion of the training set (when choosing train and validation type of training) to be reserved for training the meta-learner. Default value is 0.2.
 * @property stackMetaLearnerType The meta-learner is a model trained on the output of the individual heterogeneous models.
 */
public data class StackEnsembleSettingsArgs(
    public val stackMetaLearnerKWargs: Output<Any>? = null,
    public val stackMetaLearnerTrainPercentage: Output<Double>? = null,
    public val stackMetaLearnerType: Output<Either<String, StackMetaLearnerType>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.StackEnsembleSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.StackEnsembleSettingsArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.StackEnsembleSettingsArgs.builder()
            .stackMetaLearnerKWargs(stackMetaLearnerKWargs?.applyValue({ args0 -> args0 }))
            .stackMetaLearnerTrainPercentage(stackMetaLearnerTrainPercentage?.applyValue({ args0 -> args0 }))
            .stackMetaLearnerType(
                stackMetaLearnerType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [StackEnsembleSettingsArgs].
 */
@PulumiTagMarker
public class StackEnsembleSettingsArgsBuilder internal constructor() {
    private var stackMetaLearnerKWargs: Output<Any>? = null

    private var stackMetaLearnerTrainPercentage: Output<Double>? = null

    private var stackMetaLearnerType: Output<Either<String, StackMetaLearnerType>>? = null

    /**
     * @param value Optional parameters to pass to the initializer of the meta-learner.
     */
    @JvmName("sdcxsgkpcrieowlk")
    public suspend fun stackMetaLearnerKWargs(`value`: Output<Any>) {
        this.stackMetaLearnerKWargs = value
    }

    /**
     * @param value Specifies the proportion of the training set (when choosing train and validation type of training) to be reserved for training the meta-learner. Default value is 0.2.
     */
    @JvmName("silvdsjymluxtiav")
    public suspend fun stackMetaLearnerTrainPercentage(`value`: Output<Double>) {
        this.stackMetaLearnerTrainPercentage = value
    }

    /**
     * @param value The meta-learner is a model trained on the output of the individual heterogeneous models.
     */
    @JvmName("ntthljulxnwrporr")
    public suspend fun stackMetaLearnerType(`value`: Output<Either<String, StackMetaLearnerType>>) {
        this.stackMetaLearnerType = value
    }

    /**
     * @param value Optional parameters to pass to the initializer of the meta-learner.
     */
    @JvmName("enlcxonwagmvevuf")
    public suspend fun stackMetaLearnerKWargs(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stackMetaLearnerKWargs = mapped
    }

    /**
     * @param value Specifies the proportion of the training set (when choosing train and validation type of training) to be reserved for training the meta-learner. Default value is 0.2.
     */
    @JvmName("vxhsubmevveutbto")
    public suspend fun stackMetaLearnerTrainPercentage(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stackMetaLearnerTrainPercentage = mapped
    }

    /**
     * @param value The meta-learner is a model trained on the output of the individual heterogeneous models.
     */
    @JvmName("ghiqcyxojqvfhpoy")
    public suspend fun stackMetaLearnerType(`value`: Either<String, StackMetaLearnerType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stackMetaLearnerType = mapped
    }

    /**
     * @param value The meta-learner is a model trained on the output of the individual heterogeneous models.
     */
    @JvmName("fafnhwxxffnedgxq")
    public fun stackMetaLearnerType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, StackMetaLearnerType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stackMetaLearnerType = mapped
    }

    /**
     * @param value The meta-learner is a model trained on the output of the individual heterogeneous models.
     */
    @JvmName("ppkgdrbeuwlsejao")
    public fun stackMetaLearnerType(`value`: StackMetaLearnerType) {
        val toBeMapped = Either.ofRight<String, StackMetaLearnerType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stackMetaLearnerType = mapped
    }

    internal fun build(): StackEnsembleSettingsArgs = StackEnsembleSettingsArgs(
        stackMetaLearnerKWargs = stackMetaLearnerKWargs,
        stackMetaLearnerTrainPercentage = stackMetaLearnerTrainPercentage,
        stackMetaLearnerType = stackMetaLearnerType,
    )
}
