@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.TableVerticalLimitSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Job execution constraints.
 * @property enableEarlyTermination Enable early termination, determines whether or not if AutoMLJob will terminate early if there is no score improvement in last 20 iterations.
 * @property exitScore Exit score for the AutoML job.
 * @property maxConcurrentTrials Maximum Concurrent iterations.
 * @property maxCoresPerTrial Max cores per iteration.
 * @property maxTrials Number of iterations.
 * @property timeout AutoML job timeout.
 * @property trialTimeout Iteration timeout.
 */
public data class TableVerticalLimitSettingsArgs(
    public val enableEarlyTermination: Output<Boolean>? = null,
    public val exitScore: Output<Double>? = null,
    public val maxConcurrentTrials: Output<Int>? = null,
    public val maxCoresPerTrial: Output<Int>? = null,
    public val maxTrials: Output<Int>? = null,
    public val timeout: Output<String>? = null,
    public val trialTimeout: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.TableVerticalLimitSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.TableVerticalLimitSettingsArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.TableVerticalLimitSettingsArgs.builder()
            .enableEarlyTermination(enableEarlyTermination?.applyValue({ args0 -> args0 }))
            .exitScore(exitScore?.applyValue({ args0 -> args0 }))
            .maxConcurrentTrials(maxConcurrentTrials?.applyValue({ args0 -> args0 }))
            .maxCoresPerTrial(maxCoresPerTrial?.applyValue({ args0 -> args0 }))
            .maxTrials(maxTrials?.applyValue({ args0 -> args0 }))
            .timeout(timeout?.applyValue({ args0 -> args0 }))
            .trialTimeout(trialTimeout?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TableVerticalLimitSettingsArgs].
 */
@PulumiTagMarker
public class TableVerticalLimitSettingsArgsBuilder internal constructor() {
    private var enableEarlyTermination: Output<Boolean>? = null

    private var exitScore: Output<Double>? = null

    private var maxConcurrentTrials: Output<Int>? = null

    private var maxCoresPerTrial: Output<Int>? = null

    private var maxTrials: Output<Int>? = null

    private var timeout: Output<String>? = null

    private var trialTimeout: Output<String>? = null

    /**
     * @param value Enable early termination, determines whether or not if AutoMLJob will terminate early if there is no score improvement in last 20 iterations.
     */
    @JvmName("ccyvoxhrxffknqbn")
    public suspend fun enableEarlyTermination(`value`: Output<Boolean>) {
        this.enableEarlyTermination = value
    }

    /**
     * @param value Exit score for the AutoML job.
     */
    @JvmName("xvirqybicntopjpl")
    public suspend fun exitScore(`value`: Output<Double>) {
        this.exitScore = value
    }

    /**
     * @param value Maximum Concurrent iterations.
     */
    @JvmName("tcsbwltmixcsydgn")
    public suspend fun maxConcurrentTrials(`value`: Output<Int>) {
        this.maxConcurrentTrials = value
    }

    /**
     * @param value Max cores per iteration.
     */
    @JvmName("eqypbkubbfbbqfgy")
    public suspend fun maxCoresPerTrial(`value`: Output<Int>) {
        this.maxCoresPerTrial = value
    }

    /**
     * @param value Number of iterations.
     */
    @JvmName("aexgffllnmelccib")
    public suspend fun maxTrials(`value`: Output<Int>) {
        this.maxTrials = value
    }

    /**
     * @param value AutoML job timeout.
     */
    @JvmName("gfjallgjtrjliwkr")
    public suspend fun timeout(`value`: Output<String>) {
        this.timeout = value
    }

    /**
     * @param value Iteration timeout.
     */
    @JvmName("mtgtcboqerporrtw")
    public suspend fun trialTimeout(`value`: Output<String>) {
        this.trialTimeout = value
    }

    /**
     * @param value Enable early termination, determines whether or not if AutoMLJob will terminate early if there is no score improvement in last 20 iterations.
     */
    @JvmName("wrgkkxoxevhmtdnu")
    public suspend fun enableEarlyTermination(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableEarlyTermination = mapped
    }

    /**
     * @param value Exit score for the AutoML job.
     */
    @JvmName("agogddvlmlnvmxow")
    public suspend fun exitScore(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exitScore = mapped
    }

    /**
     * @param value Maximum Concurrent iterations.
     */
    @JvmName("lwyfpadxgennewwf")
    public suspend fun maxConcurrentTrials(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConcurrentTrials = mapped
    }

    /**
     * @param value Max cores per iteration.
     */
    @JvmName("pmijwjlpgvrdbsql")
    public suspend fun maxCoresPerTrial(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxCoresPerTrial = mapped
    }

    /**
     * @param value Number of iterations.
     */
    @JvmName("pvdncnbkgwydklja")
    public suspend fun maxTrials(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxTrials = mapped
    }

    /**
     * @param value AutoML job timeout.
     */
    @JvmName("ylyonfpavtkbfnvp")
    public suspend fun timeout(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeout = mapped
    }

    /**
     * @param value Iteration timeout.
     */
    @JvmName("ldjgewhwdtglntsm")
    public suspend fun trialTimeout(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trialTimeout = mapped
    }

    internal fun build(): TableVerticalLimitSettingsArgs = TableVerticalLimitSettingsArgs(
        enableEarlyTermination = enableEarlyTermination,
        exitScore = exitScore,
        maxConcurrentTrials = maxConcurrentTrials,
        maxCoresPerTrial = maxCoresPerTrial,
        maxTrials = maxTrials,
        timeout = timeout,
        trialTimeout = trialTimeout,
    )
}
