@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.UriFileJobOutputArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.OutputDeliveryMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property description Description for the output.
 * @property jobOutputType Enum to determine the Job Output Type.
 * Expected value is 'uri_file'.
 * @property mode Output Asset Delivery Mode.
 * @property uri Output Asset URI.
 */
public data class UriFileJobOutputArgs(
    public val description: Output<String>? = null,
    public val jobOutputType: Output<String>,
    public val mode: Output<Either<String, OutputDeliveryMode>>? = null,
    public val uri: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.UriFileJobOutputArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.UriFileJobOutputArgs = com.pulumi.azurenative.machinelearningservices.inputs.UriFileJobOutputArgs.builder()
        .description(description?.applyValue({ args0 -> args0 }))
        .jobOutputType(jobOutputType.applyValue({ args0 -> args0 }))
        .mode(
            mode?.applyValue({ args0 ->
                args0.transform({ args0 -> args0 }, { args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .uri(uri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UriFileJobOutputArgs].
 */
@PulumiTagMarker
public class UriFileJobOutputArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var jobOutputType: Output<String>? = null

    private var mode: Output<Either<String, OutputDeliveryMode>>? = null

    private var uri: Output<String>? = null

    /**
     * @param value Description for the output.
     */
    @JvmName("unbhvylmhhilsqby")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Enum to determine the Job Output Type.
     * Expected value is 'uri_file'.
     */
    @JvmName("stwoixvavapipivb")
    public suspend fun jobOutputType(`value`: Output<String>) {
        this.jobOutputType = value
    }

    /**
     * @param value Output Asset Delivery Mode.
     */
    @JvmName("koqpmtjoktkhrndt")
    public suspend fun mode(`value`: Output<Either<String, OutputDeliveryMode>>) {
        this.mode = value
    }

    /**
     * @param value Output Asset URI.
     */
    @JvmName("venwwhawhosryvri")
    public suspend fun uri(`value`: Output<String>) {
        this.uri = value
    }

    /**
     * @param value Description for the output.
     */
    @JvmName("enbnmyfbphelyfia")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Enum to determine the Job Output Type.
     * Expected value is 'uri_file'.
     */
    @JvmName("dikbolcnnrjycuuh")
    public suspend fun jobOutputType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.jobOutputType = mapped
    }

    /**
     * @param value Output Asset Delivery Mode.
     */
    @JvmName("tipnlghjxfcnkajm")
    public suspend fun mode(`value`: Either<String, OutputDeliveryMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value Output Asset Delivery Mode.
     */
    @JvmName("fiqqejbgtgjpprgt")
    public fun mode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OutputDeliveryMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value Output Asset Delivery Mode.
     */
    @JvmName("twusjdkeyfkdaxbv")
    public fun mode(`value`: OutputDeliveryMode) {
        val toBeMapped = Either.ofRight<String, OutputDeliveryMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value Output Asset URI.
     */
    @JvmName("atpbbtspwrbmcnef")
    public suspend fun uri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uri = mapped
    }

    internal fun build(): UriFileJobOutputArgs = UriFileJobOutputArgs(
        description = description,
        jobOutputType = jobOutputType ?: throw PulumiNullFieldException("jobOutputType"),
        mode = mode,
        uri = uri,
    )
}
