@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.UriFolderJobInputArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.InputDeliveryMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property description Description for the input.
 * @property jobInputType Enum to determine the Job Input Type.
 * Expected value is 'uri_folder'.
 * @property mode Input Asset Delivery Mode.
 * @property uri [Required] Input Asset URI.
 */
public data class UriFolderJobInputArgs(
    public val description: Output<String>? = null,
    public val jobInputType: Output<String>,
    public val mode: Output<Either<String, InputDeliveryMode>>? = null,
    public val uri: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.UriFolderJobInputArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.UriFolderJobInputArgs = com.pulumi.azurenative.machinelearningservices.inputs.UriFolderJobInputArgs.builder()
        .description(description?.applyValue({ args0 -> args0 }))
        .jobInputType(jobInputType.applyValue({ args0 -> args0 }))
        .mode(
            mode?.applyValue({ args0 ->
                args0.transform({ args0 -> args0 }, { args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .uri(uri.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UriFolderJobInputArgs].
 */
@PulumiTagMarker
public class UriFolderJobInputArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var jobInputType: Output<String>? = null

    private var mode: Output<Either<String, InputDeliveryMode>>? = null

    private var uri: Output<String>? = null

    /**
     * @param value Description for the input.
     */
    @JvmName("vlkedvhkmxhaordq")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Enum to determine the Job Input Type.
     * Expected value is 'uri_folder'.
     */
    @JvmName("echwvsytpyldmofe")
    public suspend fun jobInputType(`value`: Output<String>) {
        this.jobInputType = value
    }

    /**
     * @param value Input Asset Delivery Mode.
     */
    @JvmName("xoxypvvgowlblwcs")
    public suspend fun mode(`value`: Output<Either<String, InputDeliveryMode>>) {
        this.mode = value
    }

    /**
     * @param value [Required] Input Asset URI.
     */
    @JvmName("oiecjisdrynrtaes")
    public suspend fun uri(`value`: Output<String>) {
        this.uri = value
    }

    /**
     * @param value Description for the input.
     */
    @JvmName("hgvjfxkfaymeffui")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Enum to determine the Job Input Type.
     * Expected value is 'uri_folder'.
     */
    @JvmName("ovlcfricuolimmsm")
    public suspend fun jobInputType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.jobInputType = mapped
    }

    /**
     * @param value Input Asset Delivery Mode.
     */
    @JvmName("prjtfwoonjwaerho")
    public suspend fun mode(`value`: Either<String, InputDeliveryMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value Input Asset Delivery Mode.
     */
    @JvmName("sbhxksptwjgxqfka")
    public fun mode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, InputDeliveryMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value Input Asset Delivery Mode.
     */
    @JvmName("njngdrrtnsftxtdo")
    public fun mode(`value`: InputDeliveryMode) {
        val toBeMapped = Either.ofRight<String, InputDeliveryMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value [Required] Input Asset URI.
     */
    @JvmName("mxqohcwcmmgumequ")
    public suspend fun uri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.uri = mapped
    }

    internal fun build(): UriFolderJobInputArgs = UriFolderJobInputArgs(
        description = description,
        jobInputType = jobInputType ?: throw PulumiNullFieldException("jobInputType"),
        mode = mode,
        uri = uri ?: throw PulumiNullFieldException("uri"),
    )
}
