@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.VirtualMachineSchemaPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property address Public IP address of the virtual machine.
 * @property administratorAccount Admin credentials for virtual machine
 * @property isNotebookInstanceCompute Indicates whether this compute will be used for running notebooks.
 * @property notebookServerPort Notebook server port open for ssh connections.
 * @property sshPort Port open for ssh connections.
 * @property virtualMachineSize Virtual Machine size
 */
public data class VirtualMachineSchemaPropertiesArgs(
    public val address: Output<String>? = null,
    public val administratorAccount: Output<VirtualMachineSshCredentialsArgs>? = null,
    public val isNotebookInstanceCompute: Output<Boolean>? = null,
    public val notebookServerPort: Output<Int>? = null,
    public val sshPort: Output<Int>? = null,
    public val virtualMachineSize: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.VirtualMachineSchemaPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.VirtualMachineSchemaPropertiesArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.VirtualMachineSchemaPropertiesArgs.builder()
            .address(address?.applyValue({ args0 -> args0 }))
            .administratorAccount(
                administratorAccount?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .isNotebookInstanceCompute(isNotebookInstanceCompute?.applyValue({ args0 -> args0 }))
            .notebookServerPort(notebookServerPort?.applyValue({ args0 -> args0 }))
            .sshPort(sshPort?.applyValue({ args0 -> args0 }))
            .virtualMachineSize(virtualMachineSize?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualMachineSchemaPropertiesArgs].
 */
@PulumiTagMarker
public class VirtualMachineSchemaPropertiesArgsBuilder internal constructor() {
    private var address: Output<String>? = null

    private var administratorAccount: Output<VirtualMachineSshCredentialsArgs>? = null

    private var isNotebookInstanceCompute: Output<Boolean>? = null

    private var notebookServerPort: Output<Int>? = null

    private var sshPort: Output<Int>? = null

    private var virtualMachineSize: Output<String>? = null

    /**
     * @param value Public IP address of the virtual machine.
     */
    @JvmName("kaokbyfnuhuqylpw")
    public suspend fun address(`value`: Output<String>) {
        this.address = value
    }

    /**
     * @param value Admin credentials for virtual machine
     */
    @JvmName("vuputfwvacbsolew")
    public suspend fun administratorAccount(`value`: Output<VirtualMachineSshCredentialsArgs>) {
        this.administratorAccount = value
    }

    /**
     * @param value Indicates whether this compute will be used for running notebooks.
     */
    @JvmName("ieeyxbsuxkrjiiih")
    public suspend fun isNotebookInstanceCompute(`value`: Output<Boolean>) {
        this.isNotebookInstanceCompute = value
    }

    /**
     * @param value Notebook server port open for ssh connections.
     */
    @JvmName("oyhunsocvlygtvvn")
    public suspend fun notebookServerPort(`value`: Output<Int>) {
        this.notebookServerPort = value
    }

    /**
     * @param value Port open for ssh connections.
     */
    @JvmName("hyqpssusjnwsrbyb")
    public suspend fun sshPort(`value`: Output<Int>) {
        this.sshPort = value
    }

    /**
     * @param value Virtual Machine size
     */
    @JvmName("lyvbhcslwwkosxrc")
    public suspend fun virtualMachineSize(`value`: Output<String>) {
        this.virtualMachineSize = value
    }

    /**
     * @param value Public IP address of the virtual machine.
     */
    @JvmName("avmlguxakpsdllun")
    public suspend fun address(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.address = mapped
    }

    /**
     * @param value Admin credentials for virtual machine
     */
    @JvmName("qoxloafmabqegssx")
    public suspend fun administratorAccount(`value`: VirtualMachineSshCredentialsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.administratorAccount = mapped
    }

    /**
     * @param argument Admin credentials for virtual machine
     */
    @JvmName("xhikryagspsqxwco")
    public suspend fun administratorAccount(argument: suspend VirtualMachineSshCredentialsArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualMachineSshCredentialsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.administratorAccount = mapped
    }

    /**
     * @param value Indicates whether this compute will be used for running notebooks.
     */
    @JvmName("fhlqiqcjjylnwimm")
    public suspend fun isNotebookInstanceCompute(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isNotebookInstanceCompute = mapped
    }

    /**
     * @param value Notebook server port open for ssh connections.
     */
    @JvmName("njwtyshfskimrjpo")
    public suspend fun notebookServerPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notebookServerPort = mapped
    }

    /**
     * @param value Port open for ssh connections.
     */
    @JvmName("rgnftacpxotvtedg")
    public suspend fun sshPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sshPort = mapped
    }

    /**
     * @param value Virtual Machine size
     */
    @JvmName("qaeseehthnedrfyn")
    public suspend fun virtualMachineSize(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualMachineSize = mapped
    }

    internal fun build(): VirtualMachineSchemaPropertiesArgs = VirtualMachineSchemaPropertiesArgs(
        address = address,
        administratorAccount = administratorAccount,
        isNotebookInstanceCompute = isNotebookInstanceCompute,
        notebookServerPort = notebookServerPort,
        sshPort = sshPort,
        virtualMachineSize = virtualMachineSize,
    )
}
