@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.VirtualMachineSshCredentialsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Admin credentials for virtual machine
 * @property password Password of admin account
 * @property privateKeyData Private key data
 * @property publicKeyData Public key data
 * @property username Username of admin account
 */
public data class VirtualMachineSshCredentialsArgs(
    public val password: Output<String>? = null,
    public val privateKeyData: Output<String>? = null,
    public val publicKeyData: Output<String>? = null,
    public val username: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.VirtualMachineSshCredentialsArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.VirtualMachineSshCredentialsArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.VirtualMachineSshCredentialsArgs.builder()
            .password(password?.applyValue({ args0 -> args0 }))
            .privateKeyData(privateKeyData?.applyValue({ args0 -> args0 }))
            .publicKeyData(publicKeyData?.applyValue({ args0 -> args0 }))
            .username(username?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualMachineSshCredentialsArgs].
 */
@PulumiTagMarker
public class VirtualMachineSshCredentialsArgsBuilder internal constructor() {
    private var password: Output<String>? = null

    private var privateKeyData: Output<String>? = null

    private var publicKeyData: Output<String>? = null

    private var username: Output<String>? = null

    /**
     * @param value Password of admin account
     */
    @JvmName("bkiqabvtvsqgndep")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value Private key data
     */
    @JvmName("gwqxniedknqvllbr")
    public suspend fun privateKeyData(`value`: Output<String>) {
        this.privateKeyData = value
    }

    /**
     * @param value Public key data
     */
    @JvmName("brtrymfvfsqyoxmx")
    public suspend fun publicKeyData(`value`: Output<String>) {
        this.publicKeyData = value
    }

    /**
     * @param value Username of admin account
     */
    @JvmName("bwhjhdupxbbddith")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value Password of admin account
     */
    @JvmName("jwlqawjtuogdtaew")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Private key data
     */
    @JvmName("kmftcgucfvsflabv")
    public suspend fun privateKeyData(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateKeyData = mapped
    }

    /**
     * @param value Public key data
     */
    @JvmName("avdwnioufbgrlaqy")
    public suspend fun publicKeyData(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicKeyData = mapped
    }

    /**
     * @param value Username of admin account
     */
    @JvmName("pjtvxbkrrhttgkmo")
    public suspend fun username(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): VirtualMachineSshCredentialsArgs = VirtualMachineSshCredentialsArgs(
        password = password,
        privateKeyData = privateKeyData,
        publicKeyData = publicKeyData,
        username = username,
    )
}
