@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.VolumeDefinitionArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.VolumeDefinitionType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Describes the volume configuration for the container
 * @property bind Bind Options of the mount
 * @property consistency Consistency of the volume
 * @property readOnly Indicate whether to mount volume as readOnly. Default value for this is false.
 * @property source Source of the mount. For bind mounts this is the host path.
 * @property target Target of the mount. For bind mounts this is the path in the container.
 * @property tmpfs tmpfs option of the mount
 * @property type Type of Volume Definition. Possible Values: bind,volume,tmpfs,npipe
 * @property volume Volume Options of the mount
 */
public data class VolumeDefinitionArgs(
    public val bind: Output<BindOptionsArgs>? = null,
    public val consistency: Output<String>? = null,
    public val readOnly: Output<Boolean>? = null,
    public val source: Output<String>? = null,
    public val target: Output<String>? = null,
    public val tmpfs: Output<TmpfsOptionsArgs>? = null,
    public val type: Output<Either<String, VolumeDefinitionType>>? = null,
    public val volume: Output<VolumeOptionsArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.VolumeDefinitionArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.VolumeDefinitionArgs = com.pulumi.azurenative.machinelearningservices.inputs.VolumeDefinitionArgs.builder()
        .bind(bind?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .consistency(consistency?.applyValue({ args0 -> args0 }))
        .readOnly(readOnly?.applyValue({ args0 -> args0 }))
        .source(source?.applyValue({ args0 -> args0 }))
        .target(target?.applyValue({ args0 -> args0 }))
        .tmpfs(tmpfs?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .type(
            type?.applyValue({ args0 ->
                args0.transform({ args0 -> args0 }, { args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .volume(volume?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VolumeDefinitionArgs].
 */
@PulumiTagMarker
public class VolumeDefinitionArgsBuilder internal constructor() {
    private var bind: Output<BindOptionsArgs>? = null

    private var consistency: Output<String>? = null

    private var readOnly: Output<Boolean>? = null

    private var source: Output<String>? = null

    private var target: Output<String>? = null

    private var tmpfs: Output<TmpfsOptionsArgs>? = null

    private var type: Output<Either<String, VolumeDefinitionType>>? = null

    private var volume: Output<VolumeOptionsArgs>? = null

    /**
     * @param value Bind Options of the mount
     */
    @JvmName("adaxkxiiddxhgihk")
    public suspend fun bind(`value`: Output<BindOptionsArgs>) {
        this.bind = value
    }

    /**
     * @param value Consistency of the volume
     */
    @JvmName("mfnjugwedqihrxik")
    public suspend fun consistency(`value`: Output<String>) {
        this.consistency = value
    }

    /**
     * @param value Indicate whether to mount volume as readOnly. Default value for this is false.
     */
    @JvmName("dxnqcnnvjleufgfc")
    public suspend fun readOnly(`value`: Output<Boolean>) {
        this.readOnly = value
    }

    /**
     * @param value Source of the mount. For bind mounts this is the host path.
     */
    @JvmName("ftkpuifyhxneiryi")
    public suspend fun source(`value`: Output<String>) {
        this.source = value
    }

    /**
     * @param value Target of the mount. For bind mounts this is the path in the container.
     */
    @JvmName("pnvobjrvnkhbwjwu")
    public suspend fun target(`value`: Output<String>) {
        this.target = value
    }

    /**
     * @param value tmpfs option of the mount
     */
    @JvmName("vovdendgsbnjbtcj")
    public suspend fun tmpfs(`value`: Output<TmpfsOptionsArgs>) {
        this.tmpfs = value
    }

    /**
     * @param value Type of Volume Definition. Possible Values: bind,volume,tmpfs,npipe
     */
    @JvmName("xffufwyeurfyaehe")
    public suspend fun type(`value`: Output<Either<String, VolumeDefinitionType>>) {
        this.type = value
    }

    /**
     * @param value Volume Options of the mount
     */
    @JvmName("kecrvlsdvixcoelg")
    public suspend fun volume(`value`: Output<VolumeOptionsArgs>) {
        this.volume = value
    }

    /**
     * @param value Bind Options of the mount
     */
    @JvmName("wsjnrktpdbsbcdst")
    public suspend fun bind(`value`: BindOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bind = mapped
    }

    /**
     * @param argument Bind Options of the mount
     */
    @JvmName("icwswitimvltrahy")
    public suspend fun bind(argument: suspend BindOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = BindOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.bind = mapped
    }

    /**
     * @param value Consistency of the volume
     */
    @JvmName("tfqgoaipvnnsnpvc")
    public suspend fun consistency(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.consistency = mapped
    }

    /**
     * @param value Indicate whether to mount volume as readOnly. Default value for this is false.
     */
    @JvmName("hbocfhgvxlfdsqfv")
    public suspend fun readOnly(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readOnly = mapped
    }

    /**
     * @param value Source of the mount. For bind mounts this is the host path.
     */
    @JvmName("bjxvrscsjkkrhhfm")
    public suspend fun source(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param value Target of the mount. For bind mounts this is the path in the container.
     */
    @JvmName("kfqpcuxrnssegkae")
    public suspend fun target(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.target = mapped
    }

    /**
     * @param value tmpfs option of the mount
     */
    @JvmName("uftomgrctpjypjcv")
    public suspend fun tmpfs(`value`: TmpfsOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tmpfs = mapped
    }

    /**
     * @param argument tmpfs option of the mount
     */
    @JvmName("arwjfcdwaqfbxmtx")
    public suspend fun tmpfs(argument: suspend TmpfsOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = TmpfsOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tmpfs = mapped
    }

    /**
     * @param value Type of Volume Definition. Possible Values: bind,volume,tmpfs,npipe
     */
    @JvmName("gcxraxnxvldbhyqg")
    public suspend fun type(`value`: Either<String, VolumeDefinitionType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Type of Volume Definition. Possible Values: bind,volume,tmpfs,npipe
     */
    @JvmName("hsjjgfsxuiffyjvb")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VolumeDefinitionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Type of Volume Definition. Possible Values: bind,volume,tmpfs,npipe
     */
    @JvmName("kjoyxlgrkouhwygm")
    public fun type(`value`: VolumeDefinitionType) {
        val toBeMapped = Either.ofRight<String, VolumeDefinitionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Volume Options of the mount
     */
    @JvmName("xgjoanaektvtdcgh")
    public suspend fun volume(`value`: VolumeOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volume = mapped
    }

    /**
     * @param argument Volume Options of the mount
     */
    @JvmName("ukjgygiwlnochquy")
    public suspend fun volume(argument: suspend VolumeOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = VolumeOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.volume = mapped
    }

    internal fun build(): VolumeDefinitionArgs = VolumeDefinitionArgs(
        bind = bind,
        consistency = consistency,
        readOnly = readOnly,
        source = source,
        target = target,
        tmpfs = tmpfs,
        type = type,
        volume = volume,
    )
}
