@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.VolumeOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes the volume options for the container
 * @property nocopy Indicate whether volume is nocopy
 */
public data class VolumeOptionsArgs(
    public val nocopy: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.VolumeOptionsArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.VolumeOptionsArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.VolumeOptionsArgs.builder()
            .nocopy(nocopy?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VolumeOptionsArgs].
 */
@PulumiTagMarker
public class VolumeOptionsArgsBuilder internal constructor() {
    private var nocopy: Output<Boolean>? = null

    /**
     * @param value Indicate whether volume is nocopy
     */
    @JvmName("vmnmxdxvihwtekgm")
    public suspend fun nocopy(`value`: Output<Boolean>) {
        this.nocopy = value
    }

    /**
     * @param value Indicate whether volume is nocopy
     */
    @JvmName("ymawdwbqeogagtna")
    public suspend fun nocopy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nocopy = mapped
    }

    internal fun build(): VolumeOptionsArgs = VolumeOptionsArgs(
        nocopy = nocopy,
    )
}
