@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * AKS properties
 * @property agentCount Number of agents
 * @property agentVmSize Agent virtual machine size
 * @property aksNetworkingConfiguration AKS networking configuration for vnet
 * @property clusterFqdn Cluster full qualified domain name
 * @property clusterPurpose Intended usage of the cluster
 * @property loadBalancerSubnet Load Balancer Subnet
 * @property loadBalancerType Load Balancer Type
 * @property sslConfiguration SSL configuration
 * @property systemServices System services
 */
public data class AKSSchemaResponseProperties(
    public val agentCount: Int? = null,
    public val agentVmSize: String? = null,
    public val aksNetworkingConfiguration: AksNetworkingConfigurationResponse? = null,
    public val clusterFqdn: String? = null,
    public val clusterPurpose: String? = null,
    public val loadBalancerSubnet: String? = null,
    public val loadBalancerType: String? = null,
    public val sslConfiguration: SslConfigurationResponse? = null,
    public val systemServices: List<SystemServiceResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.AKSSchemaResponseProperties): AKSSchemaResponseProperties = AKSSchemaResponseProperties(
            agentCount = javaType.agentCount().map({ args0 -> args0 }).orElse(null),
            agentVmSize = javaType.agentVmSize().map({ args0 -> args0 }).orElse(null),
            aksNetworkingConfiguration = javaType.aksNetworkingConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.AksNetworkingConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            clusterFqdn = javaType.clusterFqdn().map({ args0 -> args0 }).orElse(null),
            clusterPurpose = javaType.clusterPurpose().map({ args0 -> args0 }).orElse(null),
            loadBalancerSubnet = javaType.loadBalancerSubnet().map({ args0 -> args0 }).orElse(null),
            loadBalancerType = javaType.loadBalancerType().map({ args0 -> args0 }).orElse(null),
            sslConfiguration = javaType.sslConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SslConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemServices = javaType.systemServices().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemServiceResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
