@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Cognitive Services account Model.
 * @property baseModel Base Model Identifier.
 * @property callRateLimit The call rate limit Cognitive Services account.
 * @property capabilities The capabilities.
 * @property deprecation Cognitive Services account ModelDeprecationInfo.
 * @property finetuneCapabilities The capabilities for finetune models.
 * @property format Deployment model format.
 * @property isDefaultVersion If the model is default version.
 * @property lifecycleStatus Model lifecycle status.
 * @property maxCapacity The max capacity.
 * @property name Deployment model name.
 * @property skus The list of Model Sku.
 * @property source Optional. Deployment model source ARM resource ID.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property version Optional. Deployment model version. If version is not specified, a default version will be assigned. The default version is different for different models and might change when there is new version available for a model. Default version for a model could be found from list models API.
 */
public data class AccountModelResponse(
    public val baseModel: DeploymentModelResponse? = null,
    public val callRateLimit: CallRateLimitResponse,
    public val capabilities: Map<String, String>? = null,
    public val deprecation: ModelDeprecationInfoResponse? = null,
    public val finetuneCapabilities: Map<String, String>? = null,
    public val format: String? = null,
    public val isDefaultVersion: Boolean? = null,
    public val lifecycleStatus: String? = null,
    public val maxCapacity: Int? = null,
    public val name: String? = null,
    public val skus: List<ModelSkuResponse>? = null,
    public val source: String? = null,
    public val systemData: SystemDataResponse,
    public val version: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.AccountModelResponse): AccountModelResponse = AccountModelResponse(
            baseModel = javaType.baseModel().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.DeploymentModelResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            callRateLimit = javaType.callRateLimit().let({ args0 ->
                com.pulumi.azurenative.machinelearningservices.kotlin.outputs.CallRateLimitResponse.Companion.toKotlin(args0)
            }),
            capabilities = javaType.capabilities().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            deprecation = javaType.deprecation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ModelDeprecationInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            finetuneCapabilities = javaType.finetuneCapabilities().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            format = javaType.format().map({ args0 -> args0 }).orElse(null),
            isDefaultVersion = javaType.isDefaultVersion().map({ args0 -> args0 }).orElse(null),
            lifecycleStatus = javaType.lifecycleStatus().map({ args0 -> args0 }).orElse(null),
            maxCapacity = javaType.maxCapacity().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            skus = javaType.skus().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ModelSkuResponse.Companion.toKotlin(args0)
                })
            }),
            source = javaType.source().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
