@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Suppress

/**
 * Details of ACR account to be used for the Registry
 * @property systemCreatedAcrAccount Details of system created ACR account to be used for the Registry
 * @property userCreatedAcrAccount Details of user created ACR account to be used for the Registry
 */
public data class AcrDetailsResponse(
    public val systemCreatedAcrAccount: SystemCreatedAcrAccountResponse? = null,
    public val userCreatedAcrAccount: UserCreatedAcrAccountResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.AcrDetailsResponse): AcrDetailsResponse = AcrDetailsResponse(
            systemCreatedAcrAccount = javaType.systemCreatedAcrAccount().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemCreatedAcrAccountResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            userCreatedAcrAccount = javaType.userCreatedAcrAccount().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.UserCreatedAcrAccountResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
