@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Advance configuration for AKS networking
 * @property dnsServiceIP An IP address assigned to the Kubernetes DNS service. It must be within the Kubernetes service address range specified in serviceCidr.
 * @property dockerBridgeCidr A CIDR notation IP range assigned to the Docker bridge network. It must not overlap with any Subnet IP ranges or the Kubernetes service address range.
 * @property serviceCidr A CIDR notation IP range from which to assign service cluster IPs. It must not overlap with any Subnet IP ranges.
 * @property subnetId Virtual network subnet resource ID the compute nodes belong to
 */
public data class AksNetworkingConfigurationResponse(
    public val dnsServiceIP: String? = null,
    public val dockerBridgeCidr: String? = null,
    public val serviceCidr: String? = null,
    public val subnetId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.AksNetworkingConfigurationResponse): AksNetworkingConfigurationResponse = AksNetworkingConfigurationResponse(
            dnsServiceIP = javaType.dnsServiceIP().map({ args0 -> args0 }).orElse(null),
            dockerBridgeCidr = javaType.dockerBridgeCidr().map({ args0 -> args0 }).orElse(null),
            serviceCidr = javaType.serviceCidr().map({ args0 -> args0 }).orElse(null),
            subnetId = javaType.subnetId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
