@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Compute node information related to a AmlCompute.
 * @property nodeId ID of the compute node.
 * @property nodeState State of the compute node. Values are idle, running, preparing, unusable, leaving and preempted.
 * @property port SSH port number of the node.
 * @property privateIpAddress Private IP address of the compute node.
 * @property publicIpAddress Public IP address of the compute node.
 * @property runId ID of the Experiment running on the node, if any else null.
 */
public data class AmlComputeNodeInformationResponse(
    public val nodeId: String,
    public val nodeState: String,
    public val port: Double,
    public val privateIpAddress: String,
    public val publicIpAddress: String,
    public val runId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.AmlComputeNodeInformationResponse): AmlComputeNodeInformationResponse = AmlComputeNodeInformationResponse(
            nodeId = javaType.nodeId(),
            nodeState = javaType.nodeState(),
            port = javaType.port(),
            privateIpAddress = javaType.privateIpAddress(),
            publicIpAddress = javaType.publicIpAddress(),
            runId = javaType.runId(),
        )
    }
}
