@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Any
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * AML Compute properties
 * @property allocationState Allocation state of the compute. Possible values are: steady - Indicates that the compute is not resizing. There are no changes to the number of compute nodes in the compute in progress. A compute enters this state when it is created and when no operations are being performed on the compute to change the number of compute nodes. resizing - Indicates that the compute is resizing; that is, compute nodes are being added to or removed from the compute.
 * @property allocationStateTransitionTime The time at which the compute entered its current allocation state.
 * @property currentNodeCount The number of compute nodes currently assigned to the compute.
 * @property enableNodePublicIp Enable or disable node public IP address provisioning. Possible values are: Possible values are: true - Indicates that the compute nodes will have public IPs provisioned. false - Indicates that the compute nodes will have a private endpoint and no public IPs.
 * @property errors Collection of errors encountered by various compute nodes during node setup.
 * @property isolatedNetwork Network is isolated or not
 * @property nodeStateCounts Counts of various node states on the compute.
 * @property osType Compute OS Type
 * @property propertyBag A property bag containing additional properties.
 * @property remoteLoginPortPublicAccess State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh port is closed on all nodes of the cluster. Enabled - Indicates that the public ssh port is open on all nodes of the cluster. NotSpecified - Indicates that the public ssh port is closed on all nodes of the cluster if VNet is defined, else is open all public nodes. It can be default only during cluster creation time, after creation it will be either enabled or disabled.
 * @property scaleSettings Scale settings for AML Compute
 * @property subnet Virtual network subnet resource ID the compute nodes belong to.
 * @property targetNodeCount The target number of compute nodes for the compute. If the allocationState is resizing, this property denotes the target node count for the ongoing resize operation. If the allocationState is steady, this property denotes the target node count for the previous resize operation.
 * @property userAccountCredentials Credentials for an administrator user account that will be created on each compute node.
 * @property virtualMachineImage Virtual Machine image for AML Compute - windows only
 * @property vmPriority Virtual Machine priority
 * @property vmSize Virtual Machine Size
 */
public data class AmlComputePropertiesResponse(
    public val allocationState: String,
    public val allocationStateTransitionTime: String,
    public val currentNodeCount: Int,
    public val enableNodePublicIp: Boolean? = null,
    public val errors: List<ErrorResponseResponse>,
    public val isolatedNetwork: Boolean? = null,
    public val nodeStateCounts: NodeStateCountsResponse,
    public val osType: String? = null,
    public val propertyBag: Any? = null,
    public val remoteLoginPortPublicAccess: String? = null,
    public val scaleSettings: ScaleSettingsResponse? = null,
    public val subnet: ResourceIdResponse? = null,
    public val targetNodeCount: Int,
    public val userAccountCredentials: UserAccountCredentialsResponse? = null,
    public val virtualMachineImage: VirtualMachineImageResponse? = null,
    public val vmPriority: String? = null,
    public val vmSize: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.AmlComputePropertiesResponse): AmlComputePropertiesResponse = AmlComputePropertiesResponse(
            allocationState = javaType.allocationState(),
            allocationStateTransitionTime = javaType.allocationStateTransitionTime(),
            currentNodeCount = javaType.currentNodeCount(),
            enableNodePublicIp = javaType.enableNodePublicIp().map({ args0 -> args0 }).orElse(null),
            errors = javaType.errors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ErrorResponseResponse.Companion.toKotlin(args0)
                })
            }),
            isolatedNetwork = javaType.isolatedNetwork().map({ args0 -> args0 }).orElse(null),
            nodeStateCounts = javaType.nodeStateCounts().let({ args0 ->
                com.pulumi.azurenative.machinelearningservices.kotlin.outputs.NodeStateCountsResponse.Companion.toKotlin(args0)
            }),
            osType = javaType.osType().map({ args0 -> args0 }).orElse(null),
            propertyBag = javaType.propertyBag().map({ args0 -> args0 }).orElse(null),
            remoteLoginPortPublicAccess = javaType.remoteLoginPortPublicAccess().map({ args0 ->
                args0
            }).orElse(null),
            scaleSettings = javaType.scaleSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ScaleSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            subnet = javaType.subnet().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ResourceIdResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            targetNodeCount = javaType.targetNodeCount(),
            userAccountCredentials = javaType.userAccountCredentials().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.UserAccountCredentialsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            virtualMachineImage = javaType.virtualMachineImage().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.VirtualMachineImageResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            vmPriority = javaType.vmPriority().map({ args0 -> args0 }).orElse(null),
            vmSize = javaType.vmSize().map({ args0 -> args0 }).orElse(null),
        )
    }
}
