@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * This connection type covers the generic ApiKey auth connection categories, for examples:
 * AzureOpenAI:
 *     Category:= AzureOpenAI
 *     AuthType:= ApiKey (as type discriminator)
 *     Credentials:= {ApiKey} as Microsoft.MachineLearning.AccountRP.Contracts.WorkspaceConnection.ApiKey
 *     Target:= {ApiBase}
 * CognitiveService:
 *     Category:= CognitiveService
 *     AuthType:= ApiKey (as type discriminator)
 *     Credentials:= {SubscriptionKey} as Microsoft.MachineLearning.AccountRP.Contracts.WorkspaceConnection.ApiKey
 *     Target:= ServiceRegion={serviceRegion}
 * CognitiveSearch:
 *     Category:= CognitiveSearch
 *     AuthType:= ApiKey (as type discriminator)
 *     Credentials:= {Key} as Microsoft.MachineLearning.AccountRP.Contracts.WorkspaceConnection.ApiKey
 *     Target:= {Endpoint}
 * Use Metadata property bag for ApiType, ApiVersion, Kind and other metadata fields
 * @property authType Authentication type of the connection target
 * Expected value is 'ApiKey'.
 * @property category Category of the connection
 * @property credentials Api key object for workspace connection credential.
 * @property expiryTime
 * @property metadata
 * @property target
 */
public data class ApiKeyAuthWorkspaceConnectionPropertiesResponse(
    public val authType: String,
    public val category: String? = null,
    public val credentials: WorkspaceConnectionApiKeyResponse? = null,
    public val expiryTime: String? = null,
    public val metadata: Any? = null,
    public val target: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.ApiKeyAuthWorkspaceConnectionPropertiesResponse): ApiKeyAuthWorkspaceConnectionPropertiesResponse =
            ApiKeyAuthWorkspaceConnectionPropertiesResponse(
                authType = javaType.authType(),
                category = javaType.category().map({ args0 -> args0 }).orElse(null),
                credentials = javaType.credentials().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.machinelearningservices.kotlin.outputs.WorkspaceConnectionApiKeyResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                expiryTime = javaType.expiryTime().map({ args0 -> args0 }).orElse(null),
                metadata = javaType.metadata().map({ args0 -> args0 }).orElse(null),
                target = javaType.target().map({ args0 -> args0 }).orElse(null),
            )
    }
}
