@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * AutoMLJob class.
 * Use this class for executing AutoML tasks like Classification/Regression etc.
 * See TaskType enum for all the tasks supported.
 * @property componentId ARM resource ID of the component resource.
 * @property computeId ARM resource ID of the compute resource.
 * @property description The asset description text.
 * @property displayName Display name of job.
 * @property environmentId The ARM resource ID of the Environment specification for the job.
 * This is optional value to provide, if not provided, AutoML will default this to Production AutoML curated environment version when running the job.
 * @property environmentVariables Environment variables included in the job.
 * @property experimentName The name of the experiment the job belongs to. If not set, the job is placed in the "Default" experiment.
 * @property identity Identity configuration. If set, this should be one of AmlToken, ManagedIdentity, UserIdentity or null.
 * Defaults to AmlToken if null.
 * @property isArchived Is the asset archived?
 * @property jobType Enum to determine the type of job.
 * Expected value is 'AutoML'.
 * @property outputs Mapping of output data bindings used in the job.
 * @property properties The asset property dictionary.
 * @property resources Compute Resource configuration for the job.
 * @property services List of JobEndpoints.
 * For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
 * @property status Status of the job.
 * @property tags Tag dictionary. Tags can be added, removed, and updated.
 * @property taskDetails [Required] This represents scenario which can be one of Tables/NLP/Image
 */
public data class AutoMLJobResponse(
    public val componentId: String? = null,
    public val computeId: String? = null,
    public val description: String? = null,
    public val displayName: String? = null,
    public val environmentId: String? = null,
    public val environmentVariables: Map<String, String>? = null,
    public val experimentName: String? = null,
    public val identity: Any? = null,
    public val isArchived: Boolean? = null,
    public val jobType: String,
    public val outputs: Map<String, Any>? = null,
    public val properties: Map<String, String>? = null,
    public val resources: JobResourceConfigurationResponse? = null,
    public val services: Map<String, JobServiceResponse>? = null,
    public val status: String,
    public val tags: Map<String, String>? = null,
    public val taskDetails: Any,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.AutoMLJobResponse): AutoMLJobResponse = AutoMLJobResponse(
            componentId = javaType.componentId().map({ args0 -> args0 }).orElse(null),
            computeId = javaType.computeId().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            environmentId = javaType.environmentId().map({ args0 -> args0 }).orElse(null),
            environmentVariables = javaType.environmentVariables().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            experimentName = javaType.experimentName().map({ args0 -> args0 }).orElse(null),
            identity = javaType.identity().map({ args0 -> args0 }).orElse(null),
            isArchived = javaType.isArchived().map({ args0 -> args0 }).orElse(null),
            jobType = javaType.jobType(),
            outputs = javaType.outputs().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            properties = javaType.properties().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            resources = javaType.resources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.JobResourceConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            services = javaType.services().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.machinelearningservices.kotlin.outputs.JobServiceResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            status = javaType.status(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            taskDetails = javaType.taskDetails(),
        )
    }
}
