@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

/**
 * Auto scale properties
 * @property enabled
 * @property maxNodeCount
 * @property minNodeCount
 */
public data class AutoScalePropertiesResponse(
    public val enabled: Boolean? = null,
    public val maxNodeCount: Int? = null,
    public val minNodeCount: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.AutoScalePropertiesResponse): AutoScalePropertiesResponse = AutoScalePropertiesResponse(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            maxNodeCount = javaType.maxNodeCount().map({ args0 -> args0 }).orElse(null),
            minNodeCount = javaType.minNodeCount().map({ args0 -> args0 }).orElse(null),
        )
    }
}
