@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Azure Blob datastore configuration.
 * @property accountName Storage account name.
 * @property containerName Storage account container name.
 * @property credentials [Required] Account credentials.
 * @property datastoreType Enum to determine the datastore contents type.
 * Expected value is 'AzureBlob'.
 * @property description The asset description text.
 * @property endpoint Azure cloud endpoint for the storage account.
 * @property isDefault Readonly property to indicate if datastore is the workspace default datastore
 * @property properties The asset property dictionary.
 * @property protocol Protocol used to communicate with the storage account.
 * @property serviceDataAccessAuthIdentity Indicates which identity to use to authenticate service data access to customer's storage.
 * @property tags Tag dictionary. Tags can be added, removed, and updated.
 */
public data class AzureBlobDatastoreResponse(
    public val accountName: String? = null,
    public val containerName: String? = null,
    public val credentials: Any,
    public val datastoreType: String,
    public val description: String? = null,
    public val endpoint: String? = null,
    public val isDefault: Boolean,
    public val properties: Map<String, String>? = null,
    public val protocol: String? = null,
    public val serviceDataAccessAuthIdentity: String? = null,
    public val tags: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.AzureBlobDatastoreResponse): AzureBlobDatastoreResponse = AzureBlobDatastoreResponse(
            accountName = javaType.accountName().map({ args0 -> args0 }).orElse(null),
            containerName = javaType.containerName().map({ args0 -> args0 }).orElse(null),
            credentials = javaType.credentials(),
            datastoreType = javaType.datastoreType(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            endpoint = javaType.endpoint().map({ args0 -> args0 }).orElse(null),
            isDefault = javaType.isDefault(),
            properties = javaType.properties().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            protocol = javaType.protocol().map({ args0 -> args0 }).orElse(null),
            serviceDataAccessAuthIdentity = javaType.serviceDataAccessAuthIdentity().map({ args0 ->
                args0
            }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
