@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Azure Data Lake Gen1 datastore configuration.
 * @property credentials [Required] Account credentials.
 * @property datastoreType Enum to determine the datastore contents type.
 * Expected value is 'AzureDataLakeGen1'.
 * @property description The asset description text.
 * @property isDefault Readonly property to indicate if datastore is the workspace default datastore
 * @property properties The asset property dictionary.
 * @property serviceDataAccessAuthIdentity Indicates which identity to use to authenticate service data access to customer's storage.
 * @property storeName [Required] Azure Data Lake store name.
 * @property tags Tag dictionary. Tags can be added, removed, and updated.
 */
public data class AzureDataLakeGen1DatastoreResponse(
    public val credentials: Any,
    public val datastoreType: String,
    public val description: String? = null,
    public val isDefault: Boolean,
    public val properties: Map<String, String>? = null,
    public val serviceDataAccessAuthIdentity: String? = null,
    public val storeName: String,
    public val tags: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.AzureDataLakeGen1DatastoreResponse): AzureDataLakeGen1DatastoreResponse = AzureDataLakeGen1DatastoreResponse(
            credentials = javaType.credentials(),
            datastoreType = javaType.datastoreType(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            isDefault = javaType.isDefault(),
            properties = javaType.properties().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            serviceDataAccessAuthIdentity = javaType.serviceDataAccessAuthIdentity().map({ args0 ->
                args0
            }).orElse(null),
            storeName = javaType.storeName(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
