@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property authorityUrl The authority URL used for authentication.
 * @property certificate The content of the certificate used for authentication.
 * @property clientId The Client ID/Application ID
 * @property clientSecret The client secret.
 * @property credentialType The Azure Data Lake credential type.
 * @property isCertAuth  Is it using certificate to authenticate. If false then use client secret.
 * @property resourceGroup Resource Group.
 * @property resourceUri The resource the service principal/app has access to.
 * @property serviceDataAccessAuthIdentity Indicates which identity to use to authenticate service data access to customer's storage.
 * @property storeName The Azure Data Lake store name.
 * @property subscriptionId Subscription ID.
 * @property tenantId The ID of the tenant the service principal/app belongs to.
 * @property thumbprint The thumbprint of the certificate above.
 */
public data class AzureDataLakeSectionResponse(
    public val authorityUrl: String? = null,
    public val certificate: String? = null,
    public val clientId: String? = null,
    public val clientSecret: String? = null,
    public val credentialType: String? = null,
    public val isCertAuth: Boolean? = null,
    public val resourceGroup: String? = null,
    public val resourceUri: String? = null,
    public val serviceDataAccessAuthIdentity: String? = null,
    public val storeName: String? = null,
    public val subscriptionId: String? = null,
    public val tenantId: String? = null,
    public val thumbprint: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.AzureDataLakeSectionResponse): AzureDataLakeSectionResponse = AzureDataLakeSectionResponse(
            authorityUrl = javaType.authorityUrl().map({ args0 -> args0 }).orElse(null),
            certificate = javaType.certificate().map({ args0 -> args0 }).orElse(null),
            clientId = javaType.clientId().map({ args0 -> args0 }).orElse(null),
            clientSecret = javaType.clientSecret().map({ args0 -> args0 }).orElse(null),
            credentialType = javaType.credentialType().map({ args0 -> args0 }).orElse(null),
            isCertAuth = javaType.isCertAuth().map({ args0 -> args0 }).orElse(null),
            resourceGroup = javaType.resourceGroup().map({ args0 -> args0 }).orElse(null),
            resourceUri = javaType.resourceUri().map({ args0 -> args0 }).orElse(null),
            serviceDataAccessAuthIdentity = javaType.serviceDataAccessAuthIdentity().map({ args0 ->
                args0
            }).orElse(null),
            storeName = javaType.storeName().map({ args0 -> args0 }).orElse(null),
            subscriptionId = javaType.subscriptionId().map({ args0 -> args0 }).orElse(null),
            tenantId = javaType.tenantId().map({ args0 -> args0 }).orElse(null),
            thumbprint = javaType.thumbprint().map({ args0 -> args0 }).orElse(null),
        )
    }
}
