@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Webhook details specific for Azure DevOps
 * @property eventType Send callback on a specified notification event
 * @property webhookType Enum to determine the webhook callback service type.
 * Expected value is 'AzureDevOps'.
 */
public data class AzureDevOpsWebhookResponse(
    public val eventType: String? = null,
    public val webhookType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.AzureDevOpsWebhookResponse): AzureDevOpsWebhookResponse = AzureDevOpsWebhookResponse(
            eventType = javaType.eventType().map({ args0 -> args0 }).orElse(null),
            webhookType = javaType.webhookType(),
        )
    }
}
