@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Azure File datastore configuration.
 * @property accountName [Required] Storage account name.
 * @property credentials [Required] Account credentials.
 * @property datastoreType Enum to determine the datastore contents type.
 * Expected value is 'AzureFile'.
 * @property description The asset description text.
 * @property endpoint Azure cloud endpoint for the storage account.
 * @property fileShareName [Required] The name of the Azure file share that the datastore points to.
 * @property isDefault Readonly property to indicate if datastore is the workspace default datastore
 * @property properties The asset property dictionary.
 * @property protocol Protocol used to communicate with the storage account.
 * @property serviceDataAccessAuthIdentity Indicates which identity to use to authenticate service data access to customer's storage.
 * @property tags Tag dictionary. Tags can be added, removed, and updated.
 */
public data class AzureFileDatastoreResponse(
    public val accountName: String,
    public val credentials: Any,
    public val datastoreType: String,
    public val description: String? = null,
    public val endpoint: String? = null,
    public val fileShareName: String,
    public val isDefault: Boolean,
    public val properties: Map<String, String>? = null,
    public val protocol: String? = null,
    public val serviceDataAccessAuthIdentity: String? = null,
    public val tags: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.AzureFileDatastoreResponse): AzureFileDatastoreResponse = AzureFileDatastoreResponse(
            accountName = javaType.accountName(),
            credentials = javaType.credentials(),
            datastoreType = javaType.datastoreType(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            endpoint = javaType.endpoint().map({ args0 -> args0 }).orElse(null),
            fileShareName = javaType.fileShareName(),
            isDefault = javaType.isDefault(),
            properties = javaType.properties().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            protocol = javaType.protocol().map({ args0 -> args0 }).orElse(null),
            serviceDataAccessAuthIdentity = javaType.serviceDataAccessAuthIdentity().map({ args0 ->
                args0
            }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
