@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Defines an early termination policy based on slack criteria, and a frequency and delay interval for evaluation
 * @property delayEvaluation Number of intervals by which to delay the first evaluation.
 * @property evaluationInterval Interval (number of runs) between policy evaluations.
 * @property policyType
 * Expected value is 'Bandit'.
 * @property slackAmount Absolute distance allowed from the best performing run.
 * @property slackFactor Ratio of the allowed distance from the best performing run.
 */
public data class BanditPolicyResponse(
    public val delayEvaluation: Int? = null,
    public val evaluationInterval: Int? = null,
    public val policyType: String,
    public val slackAmount: Double? = null,
    public val slackFactor: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.BanditPolicyResponse): BanditPolicyResponse = BanditPolicyResponse(
            delayEvaluation = javaType.delayEvaluation().map({ args0 -> args0 }).orElse(null),
            evaluationInterval = javaType.evaluationInterval().map({ args0 -> args0 }).orElse(null),
            policyType = javaType.policyType(),
            slackAmount = javaType.slackAmount().map({ args0 -> args0 }).orElse(null),
            slackFactor = javaType.slackFactor().map({ args0 -> args0 }).orElse(null),
        )
    }
}
