@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Batch endpoint configuration.
 * @property authMode [Required] Use 'Key' for key based authentication and 'AMLToken' for Azure Machine Learning token-based authentication. 'Key' doesn't expire but 'AMLToken' does.
 * @property defaults Default values for Batch Endpoint
 * @property description Description of the inference endpoint.
 * @property properties Property dictionary. Properties can be added, but not removed or altered.
 * @property provisioningState Provisioning state for the endpoint.
 * @property scoringUri Endpoint URI.
 * @property swaggerUri Endpoint Swagger URI.
 */
public data class BatchEndpointResponse(
    public val authMode: String,
    public val defaults: BatchEndpointDefaultsResponse? = null,
    public val description: String? = null,
    public val properties: Map<String, String>? = null,
    public val provisioningState: String,
    public val scoringUri: String,
    public val swaggerUri: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.BatchEndpointResponse): BatchEndpointResponse = BatchEndpointResponse(
            authMode = javaType.authMode(),
            defaults = javaType.defaults().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.BatchEndpointDefaultsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            properties = javaType.properties().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            provisioningState = javaType.provisioningState(),
            scoringUri = javaType.scoringUri(),
            swaggerUri = javaType.swaggerUri(),
        )
    }
}
