@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Double
import kotlin.Suppress
import kotlin.collections.List

/**
 * The call rate limit Cognitive Services account.
 * @property count The count value of Call Rate Limit.
 * @property renewalPeriod The renewal period in seconds of Call Rate Limit.
 * @property rules
 */
public data class CallRateLimitResponse(
    public val count: Double? = null,
    public val renewalPeriod: Double? = null,
    public val rules: List<ThrottlingRuleResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.CallRateLimitResponse): CallRateLimitResponse = CallRateLimitResponse(
            count = javaType.count().map({ args0 -> args0 }).orElse(null),
            renewalPeriod = javaType.renewalPeriod().map({ args0 -> args0 }).orElse(null),
            rules = javaType.rules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ThrottlingRuleResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
