@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List

/**
 * The capacity configuration.
 * @property allowedValues The array of allowed values for capacity.
 * @property default The default capacity.
 * @property maximum The maximum capacity.
 * @property minimum The minimum capacity.
 * @property step The minimal incremental between allowed values for capacity.
 */
public data class CapacityConfigResponse(
    public val allowedValues: List<Int>? = null,
    public val default: Int? = null,
    public val maximum: Int? = null,
    public val minimum: Int? = null,
    public val step: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.CapacityConfigResponse): CapacityConfigResponse = CapacityConfigResponse(
            allowedValues = javaType.allowedValues().map({ args0 -> args0 }),
            default = javaType.default_().map({ args0 -> args0 }).orElse(null),
            maximum = javaType.maximum().map({ args0 -> args0 }).orElse(null),
            minimum = javaType.minimum().map({ args0 -> args0 }).orElse(null),
            step = javaType.step().map({ args0 -> args0 }).orElse(null),
        )
    }
}
